<?php
namespace BuddyBossApp\Api\Learner\LearnDash;
use stdClass;
use WP_Query;

// NOTE : Old classname was class.bbapp_learner_learndash_badges_rest. By Ketan, Oct-2019
// Contain functionality for required additional rest api endpoints for learndash - v1 Standard
class BadgesRest {

	/**
	 * BadgesRest constructor.
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 *
	 */
	public function hooks() {
		add_filter('bbapp_learner_get_badges_items_permissions', array($this, 'getItemsPermissions'), 10, 2);
		add_filter('bbapp_learner_get_badges', array($this, "getBadges"), 10, 2);
		add_filter('bbapp_learner_get_points', array($this, "getPoints"), 10, 2);
		add_filter('bbapp_learner_get_user_points', array($this, "getUserPoints"), 10, 2);
	}

	/**
	 * @param $flag
	 * @param $request
	 *
	 * @return bool
	 */
	public function getItemsPermissions($flag, $request) {
		return true;
	}

	/**
	 * @param $query_args
	 * @param $request
	 *
	 * @return array
	 */
	public function getBadges($query_args, $request) {

		if (!empty($request['user_id'])) {
			$user_id = (int) $request['user_id'];
		} else {
			$user_id = get_current_user_id();
		}

		$badges = array();

		if (class_exists('BadgeOS') && class_exists('BadgeOS_LearnDash')) {
			// don't load if badgeos learndash is not enabled.

			$type = badgeos_get_achievement_types_slugs();
			// Drop steps from our list of "all" achievements
			$step_key = array_search('step', $type);
			if ($step_key) {
				unset($type[$step_key]);
			}

			$type = apply_filters('bbapp_learner_learndash_badges_types', $type);

			$earned_ids = badgeos_get_user_earned_achievement_ids($user_id, $type);
			if (empty($earned_ids)) {
				$earned_ids = array(0);
			}

			$args = array(
				'post_type' => $type,
				'post_status' => 'publish',
				'post__in' => $earned_ids,
				'order' => isset($request['order']) ? $request['order'] : 'Desc',
				'orderby' => isset($request['orderby']) ? $request['order'] : 'date',
			);

			// Loop Achievements
			$achievement_posts = new WP_Query($args);

			if ($achievement_posts->have_posts()) {
				foreach ($achievement_posts->posts as $achievement) {

					$badge = new stdClass();
					$badge->ID = $achievement->ID;
					$badge->title = get_the_title($achievement->ID);
					$badge->link = get_permalink($achievement->ID);
					$badge->content = !empty($achievement->post_excerpt) ? $achievement->post_excerpt : $achievement->post_content;
					$badge->points = get_post_meta($achievement->ID, '_badgeos_points', true);
					$badge->image = bbapp_lms_badgeos_get_achievement_post_thumbnail_url($achievement->ID);
					$badges[] = $badge;
				}
			}
		}

		return array('posts' => $badges);

	}

	/**
	 * @param $points
	 * @param $user_id
	 *
	 * @return int
	 */
	public function getPoints($points, $user_id) {
		if (function_exists('badgeos_get_point_types')) {
			$points = 0;
			$credit_types = badgeos_get_point_types();
			if (is_array($credit_types) && !empty($credit_types)) {
				foreach ($credit_types as $credit_type) {
					$_point = (int) badgeos_get_points_by_type($credit_type->ID, $user_id);
					$points = $points + $_point;
				}
			}
			return $points;
		} else {
			return badgeos_get_users_points($user_id);
		}
	}

	/**
	 * @param $points
	 * @param $user_id
	 *
	 * @return array
	 */
	public function getUserPoints($points, $user_id) {
		if (function_exists('badgeos_get_point_types')) {
			$points = array();
			$credit_types = badgeos_get_point_types();
			if (is_array($credit_types) && !empty($credit_types)) {
				foreach ($credit_types as $credit_type) {
					$_point = (int) badgeos_get_points_by_type($credit_type->ID, $user_id);
					$points[] = array(
						'point' => $_point,
						'label' => $credit_type->post_title,
					);
				}
			}
			return $points;
		} else {
			return array(
				array(
					'point' => badgeos_get_users_points($user_id),
					'label' => 'Points',
				),
			);
		}
	}

}