<?php
namespace BuddyBossApp\Api\Learner;
// Note : The soul purpose of this class is apidoc(documentation generator). By Ketan
class ApidocV1 {

	/**
	 * Find more @ https://codex.wordpress.org/Class_Reference/WP_Query
	 */
	private function wpQueryParamsV1() {

		/**
		 * @apiDefine wpQueryParamsV1
		 *
		 * @apiParam {String} [after] Limit response to resources published after a given ISO8601 compliant date.
		 * @apiParam {String} [before] Limit response to resources published before a given ISO8601 compliant date.
		 * @apiParam {Array} [author=array()] Limit result set to posts assigned to specific authors.(Backend WP_Query: author__in)
		 * @apiParam {Array} [author_exclude=array()] Ensure result set excludes posts assigned to specific authors.(Backend WP_Query: author__not_in)
		 * @apiParam {Array} [exclude=array()] Ensure result set excludes specific ids.(Backend WP_Query: post__not_in)
		 * @apiParam {Array} [include=array()] Limit result set to specific ids.(Backend WP_Query: post__in)
		 * @apiParam {Number} [offset] Offset the result set by a specific number of items.
		 * @apiParam {String=asc,desc} [order=desc] Order sort attribute ascending or descending.(Backend WP_Query: order)
		 * @apiParam {String=date,id,include,title,slug,menu_order} [orderby=date] Sort collection by object attribute.(Backend WP_Query: orderby)
		 * @apiParam {Array} [parent=array()] Limit result set to those of particular parent ids.(Backend WP_Query: post_parent__in)
		 * @apiParam {Array} [parent_exclude=array()] Limit result set to all items except those of a particular parent id.(Backend WP_Query: post_parent__not_in)
		 * @apiParam {String} [slug] Limit result set to posts with a specific slug.(Backend WP_Query: post_name__in)
		 * @apiParam {String} [filter] Use WP Query arguments to modify the response; private query vars require appropriate authorization.
		 * @apiParam {Array[][]} [categories=array()] Limit result set to all items that have the specified term assigned
		 * @apiParam {Array[][]} [categories_exclude=array()] Limit result set to all items that have the specified term assigned
		 * @apiParam {Array} [tags=array()] Limit result set to all items that have the specified term assigned
		 * @apiParam {Array} [tags_exclude=array()] Limit result set to all items except those that have the specified term assigned
		 */
	}

	private function apidocForLearnerCourseCategoriesV1() {
		/**
		 * @apiDefine apidocForLearnerCourseCategoriesV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String=view,edit,embed} [context=view]
		 * @apiParam {Array} [exclude=array()] Ensure result set excludes specific ids.(Backend WP_Query: post__not_in)
		 * @apiParam {Array} [include=array()] Limit result set to specific ids.(Backend WP_Query: post__in)
		 * @apiParam {Array} [courses_exclude=array()] Ensure result set excludes specific courses ids.
		 * @apiParam {String=asc,desc} [order=desc] Order sort attribute ascending or descending.(Backend WP_Query: order)
		 * @apiParam {Boolean} [hide=false] Whether to hide terms not assigned to any items.
		 * @apiParam {String=date,name,id,slug,term_group,term_id,description,parent} [orderby=name] Sort collection by object attribute.(Backend WP_Query: orderby)
		 */
	}

	private function apidocForLearnerCoursesV1() {
		/**
		 * @apiDefine apidocForLearnerCoursesV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String} [after] Limit response to resources published after a given ISO8601 compliant date.
		 * @apiParam {String} [before] Limit response to resources published before a given ISO8601 compliant date.
		 * @apiParam {Array} [author=array()] Limit result set to posts assigned to specific authors.(Backend WP_Query: author__in)
		 * @apiParam {Array} [author_exclude=array()] Ensure result set excludes posts assigned to specific authors.(Backend WP_Query: author__not_in)
		 * @apiParam {Array} [exclude=array()] Ensure result set excludes specific ids.(Backend WP_Query: post__not_in)
		 * @apiParam {Array} [include=array()] Limit result set to specific ids.(Backend WP_Query: post__in)
		 * @apiParam {Number} [offset] Offset the result set by a specific number of items.
		 * @apiParam {String=asc,desc} [order=desc] Order sort attribute ascending or descending.(Backend WP_Query: order)
		 * @apiParam {String=date,id,include,title,slug,menu_order} [orderby=date] Sort collection by object attribute.(Backend WP_Query: orderby)
		 * @apiParam {Array} [parent=array()] Limit result set to those of particular parent ids.(Backend WP_Query: post_parent__in)
		 * @apiParam {Array} [parent_exclude=array()] Limit result set to all items except those of a particular parent id.(Backend WP_Query: post_parent__not_in)
		 * @apiParam {String} [slug] Limit result set to posts with a specific slug.(Backend WP_Query: post_name__in)
		 * @apiParam {String} [filter] Use WP Query arguments to modify the response; private query vars require appropriate authorization.
		 * @apiParam {Array[][]} [categories=array()] Limit result set to all items that have the specified term assigned
		 * @apiParam {Array[][]} [categories_exclude=array()] Limit result set to all items that have the specified term assigned
		 * @apiParam {Array} [tags=array()] Limit result set to all items that have the specified term assigned
		 * @apiParam {Array} [tags_exclude=array()] Limit result set to all items except those that have the specified term assigned
		 */
	}

	private function apidocForLearnerCourseMembersV1() {
		/**
		 * @apiDefine apidocForLearnerCourseMembersV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} id Course ID
		 * @apiParam {Number} recommended Limit result set to posts which is recommended
		 * @apiParam {Number} mycourses Limit response to resources which is taked by current user.
		 * @apiParam {String} [after] Limit response to resources published after a given ISO8601 compliant date.
		 * @apiParam {String} [before] Limit response to resources published before a given ISO8601 compliant date.
		 * @apiParam {Array} [author=array()] Limit result set to posts assigned to specific authors.(Backend WP_Query: author__in)
		 * @apiParam {Array} [author_exclude=array()] Ensure result set excludes posts assigned to specific authors.(Backend WP_Query: author__not_in)
		 * @apiParam {Array} [exclude=array()] Ensure result set excludes specific ids.(Backend WP_Query: post__not_in)
		 * @apiParam {Array} [include=array()] Limit result set to specific ids.(Backend WP_Query: post__in)
		 * @apiParam {Number} offset Offset the result set by a specific number of items.
		 * @apiParam {String=asc,desc} [order=desc] Order sort attribute ascending or descending.(Backend WP_Query: order)
		 * @apiParam {String=date,id,include,title,slug,menu_order} [orderby=date] Sort collection by object attribute.
		 * @apiParam {Array} [parent=array()] Limit result set to those of particular parent ids.(Backend WP_Query: post_parent__in)
		 * @apiParam {Array} [parent_exclude=array()] Limit result set to all items except those of a particular parent id.(Backend WP_Query: post_parent__not_in)
		 * @apiParam {String} [slug] Limit result set to posts with a specific slug.(Backend WP_Query: post_name__in)
		 * @apiParam {String} [filter] Use WP Query arguments to modify the response; private query vars require appropriate authorization.
		 * @apiParam {Array[][]} [categories=array()] Limit result set to all items that have the specified term assigned
		 * @apiParam {Array[][]} [categories_exclude=array()] Limit result set to all items that have the specified term assigned
		 * @apiParam {Array} [author_exclude=array()] Ensure result set excludes posts assigned to specific authors.
		 * @apiParam {Array} [tags=array()] Limit result set to all items that have the specified term assigned
		 * @apiParam {Array} [tags_exclude=array()] Limit result set to all items except those that have the specified term assigned
		 */

	}

	private function apidocForLearnerLessonsV1() {
		/**
		 * @apiDefine apidocForLearnerLessonsV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String=view,embed,edit} [context=view] Scope under which the request is made; determines fields present in response.
		 * @apiParam {Number{1-∞}} [page=1] Current page of the collection.
		 * @apiParam {Number{1-100}} [per_page=10] Maximum number of items to be returned in result set.
		 * @apiParam {String} [after] Limit response to resources published after a given ISO8601 compliant date.
		 * @apiParam {String} [before] Limit response to resources published before a given ISO8601 compliant date.
		 * @apiParam {Array} [author=array()] Limit result set to posts assigned to specific authors.(Backend WP_Query: author__in)
		 * @apiParam {Array} [author_exclude=array()] Ensure result set excludes posts assigned to specific authors.(Backend WP_Query: author__not_in)
		 * @apiParam {Array} [exclude=array()] Ensure result set excludes specific ids.(Backend WP_Query: post__not_in)
		 * @apiParam {Array} [include=array()] Limit result set to specific ids.(Backend WP_Query: post__in)
		 * @apiParam {Number} [offset] Offset the result set by a specific number of items.
		 * @apiParam {String=asc,desc} [order=desc] Order sort attribute ascending or descending.(Backend WP_Query: order)
		 * @apiParam {String=date,id,include,title,slug,menu_order} [orderby=date] Sort collection by object attribute.(Backend WP_Query: orderby)
		 * @apiParam {Array} [parent=array()] Limit result set to those of particular parent ids.(Backend WP_Query: post_parent__in)
		 * @apiParam {Array} [parent_exclude=array()] Limit result set to all items except those of a particular parent id.(Backend WP_Query: post_parent__not_in)
		 * @apiParam {String} [slug] Limit result set to posts with a specific slug.(Backend WP_Query: post_name__in)
		 * @apiParam {String} [filter] Use WP Query arguments to modify the response; private query vars require appropriate authorization.
		 */

	}

	private function apidocForLearnerAllQuizV1() {
		/**
		 * @apiDefine apidocForLearnerAllQuizV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String} [after] Limit response to resources published after a given ISO8601 compliant date.
		 * @apiParam {String} [before] Limit response to resources published before a given ISO8601 compliant date.
		 * @apiParam {Array} [author=array()] Limit result set to posts assigned to specific authors.(Backend WP_Query: author__in)
		 * @apiParam {Array} [author_exclude=array()] Ensure result set excludes posts assigned to specific authors.(Backend WP_Query: author__not_in)
		 * @apiParam {Array} [exclude=array()] Ensure result set excludes specific ids.(Backend WP_Query: post__not_in)
		 * @apiParam {Array} [include=array()] Limit result set to specific ids.(Backend WP_Query: post__in)
		 * @apiParam {Number} [offset] Offset the result set by a specific number of items.
		 * @apiParam {String=asc,desc} [order=desc] Order sort attribute ascending or descending.(Backend WP_Query: order)
		 * @apiParam {String=date,id,include,title,slug,menu_order} [orderby=date] Sort collection by object attribute.(Backend WP_Query: orderby)
		 * @apiParam {Array} [parent=array()] Limit result set to those of particular parent ids.(Backend WP_Query: post_parent__in)
		 * @apiParam {Array} [parent_exclude=array()] Limit result set to all items except those of a particular parent id.(Backend WP_Query: post_parent__not_in)
		 * @apiParam {String} [slug] Limit result set to posts with a specific slug.(Backend WP_Query: post_name__in)
		 * @apiParam {String} [filter] Use WP Query arguments to modify the response; private query vars require appropriate authorization.
		 */
	}

	private function apidocForLearnerAllTopicsV1() {
		/**
		 * @apiDefine apidocForLearnerAllTopicsV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String} [after] Limit response to resources published after a given ISO8601 compliant date.
		 * @apiParam {String} [before] Limit response to resources published before a given ISO8601 compliant date.
		 * @apiParam {Number} [per_page] Maximum number of items to be returned in result set.(Backend WP_Query: posts_per_page)
		 * @apiParam {String} [sticky]
		 * @apiParam {Array} [author=array()] Limit result set to posts assigned to specific authors.(Backend WP_Query: author__in)
		 * @apiParam {Array} [author_exclude=array()] Ensure result set excludes posts assigned to specific authors.(Backend WP_Query: author__not_in)
		 * @apiParam {Array} [exclude=array()] Ensure result set excludes specific ids.(Backend WP_Query: post__not_in)
		 * @apiParam {Array} [include=array()] Limit result set to specific ids.(Backend WP_Query: post__in)
		 * @apiParam {Number} [offset] Offset the result set by a specific number of items.
		 * @apiParam {String=asc,desc} [order=desc] Order sort attribute ascending or descending.(Backend WP_Query: order)
		 * @apiParam {String=date,id,include,title,slug,menu_order} [orderby=date] Sort collection by object attribute.(Backend WP_Query: orderby)
		 * @apiParam {Array} [parent=array()] Limit result set to those of particular parent ids.(Backend WP_Query: post_parent__in)
		 * @apiParam {Array} [parent_exclude] Limit result set to all items except those of a particular parent id. (Backend WP_Query: post_parent__not_in)
		 * @apiParam {String} [slug] Limit result set to posts with a specific slug.(Backend WP_Query: post_name__in) (Backend WP_Query: post_name__in)
		 * @apiParam {String} [filter] Use WP Query arguments to modify the response; private query vars require appropriate authorization.
		 */
	}

	private function apidocForLearnerCertificatesV1() {
		/**
		 * @apiDefine apidocForLearnerCertificatesV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String=view,edit,embed} [context=view]
		 */
	}

	private function apidocGetLearnerCourseV1() {
		/**
		 * @apiDefine apidocGetLearnerCourseV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} id Unique Identifier
		 * @apiParam {String=view,edit,embed} [context=view]
		 */
	}

	private function apidocGetLearnerCourseIdsV1() {
		/**
		 * @apiDefine apidocGetLearnerCourseIdsV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String=true,false} [mycourse=false]
		 */
	}

}