<?php
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'boss_buddypress_rest_api_convert_date' ) ) {
	function boss_buddypress_rest_api_convert_date( $date ) {
		return mysql_to_rfc3339( get_date_from_gmt( $date ) );
	}

}

/**
 * Function strips unwanted links added by buddypress media plugin.
 * In frontend those link are hidden by CSS. but we cannot do same for API so ending up striping them.
 */
if ( ! function_exists( "boss_buddyboss_rest_activity_buddyboss_media_fix" ) ) {
	add_filter( "rest_prepare_boss_buddypress_activity", "boss_buddyboss_rest_activity_buddyboss_media_fix" );

	function boss_buddyboss_rest_activity_buddyboss_media_fix( $response ) {
		$response->data["content"] = preg_replace( '#<a[^>]+class="buddyboss-media-photo-link"[^>]*>.*?</a>#is', '',
			$response->data["content"] );

		return $response;
	}
}

/**
 * Get activity avatar url
 */
if ( ! function_exists( 'boss_bp_get_activity_avatar_url' ) ) {

	function boss_bp_get_activity_avatar_url( $args = '' ) {
		global $activities_template;

		$bp = buddypress();

		// On activity permalink pages, default to the full-size avatar.
		$type_default = bp_is_single_activity() ? 'full' : 'thumb';

		// Within the activity comment loop, the current activity should be set
		// to current_comment. Otherwise, just use activity.
		$current_activity_item = isset( $activities_template->activity->current_comment ) ? $activities_template->activity->current_comment : $activities_template->activity;

		// Activity user display name.
		$dn_default = isset( $current_activity_item->display_name ) ? $current_activity_item->display_name : '';

		// Prepend some descriptive text to alt.
		$alt_default = ! empty( $dn_default ) ? sprintf( __( 'Profile picture of %s', 'buddypress' ), $dn_default ) : __( 'Profile picture', 'buddypress' );

		$defaults = array(
			'alt'     => $alt_default,
			'class'   => 'avatar',
			'email'   => false,
			'type'    => $type_default,
			'user_id' => false
		);

		$r = wp_parse_args( $args, $defaults );
		extract( $r, EXTR_SKIP );

		if ( ! isset( $height ) && ! isset( $width ) ) {

			// Backpat.
			if ( isset( $bp->avatar->full->height ) || isset( $bp->avatar->thumb->height ) ) {
				$height = ( 'full' == $type ) ? $bp->avatar->full->height : $bp->avatar->thumb->height;
			} else {
				$height = 20;
			}

			// Backpat.
			if ( isset( $bp->avatar->full->width ) || isset( $bp->avatar->thumb->width ) ) {
				$width = ( 'full' == $type ) ? $bp->avatar->full->width : $bp->avatar->thumb->width;
			} else {
				$width = 20;
			}
		}

		/**
		 * Filters the activity avatar object based on current activity item component.
		 *
		 * This is a variable filter dependent on the component used.
		 * Possible hooks are bp_get_activity_avatar_object_blog,
		 * bp_get_activity_avatar_object_group, and bp_get_activity_avatar_object_user.
		 *
		 * @since 1.1.0
		 *
		 * @param string $component Component being displayed.
		 */
		$object  = apply_filters( 'bp_get_activity_avatar_object_' . $current_activity_item->component, 'user' );
		$item_id = ! empty( $user_id ) ? $user_id : $current_activity_item->user_id;

		/**
		 * Filters the activity avatar item ID.
		 *
		 * @since 1.2.10
		 *
		 * @param int $item_id Item ID for the activity avatar.
		 */
		$item_id = apply_filters( 'bp_get_activity_avatar_item_id', $item_id );

		// If this is a user object pass the users' email address for Gravatar so we don't have to prefetch it.
		if ( 'user' == $object && empty( $user_id ) && empty( $email ) && isset( $current_activity_item->user_email ) ) {
			$email = $current_activity_item->user_email;
		}

		/**
		 * Filters the value returned by bp_core_fetch_avatar.
		 *
		 * @since 1.1.3
		 *
		 * @param array $value HTML image element containing the activity avatar.
		 */
		return apply_filters( 'bp_get_activity_avatar', bp_core_fetch_avatar( array(
			'item_id' => $item_id,
			'object'  => $object,
			'type'    => $type,
			'alt'     => $alt,
			'class'   => $class,
			'width'   => $width,
			'height'  => $height,
			'email'   => $email,
			'html'   => false
		) ) );
	}
}

if ( ! function_exists( 'boss_bp_rest_get_user_url' ) ) {
	/**
	 * Get user URL.
	 *
	 * @since 0.1.0
	 *
	 * @param  int|array $users User IDs.
	 * @return string
	 */

	function boss_bp_rest_get_user_url( $users ) {
		if ( is_array( $users ) ) {
			return sprintf(
				'/%s/%s/members?include=%s',
				'appboss/buddypress',
				'v1',
				implode( ',', $users )
			);
		}

		return sprintf(
			'/%s/%s/members/%d',
			'appboss/buddypress',
			'v1',
			$users
		);

	}
}

