<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

// Note : All functions using(overriding) filters/actions for buddypress component should reside here

// @todo : Add proper description here
if ( ! function_exists( 'get_total_members' ) ) {
	function get_total_members( $byType = 'alphabetical' ) {

		$count = 0;

		$args = array(
			'type' => $byType,
		);

		//BuddyBoss Platform exclude member type user support
		if ( function_exists( 'bp_get_removed_member_types' ) ) {
			$bp_member_type_ids = bp_get_removed_member_types();
			// get removed profile type names/slugs
			$bp_member_type_names = array();
			if ( isset( $bp_member_type_ids ) && ! empty( $bp_member_type_ids ) ) {
				foreach ( $bp_member_type_ids as $single ) {
					$bp_member_type_names[] = $single['name'];
				}
			}
			$args['member_type__not_in'] = $bp_member_type_names;
		}

		$bpCoreGetUsers = bp_core_get_users( $args );

		if ( ! empty( $bpCoreGetUsers ) && isset( $bpCoreGetUsers['total'] ) ) {
			$count = $bpCoreGetUsers['total'];
		}

		return $count;

	}
}

// @todo : Add proper description here
if ( ! function_exists( 'get_total_friends' ) ) {
	function get_total_friends( $userId, $byType = 'alphabetical' ) {

		$count = - 1; //if buddypress friends component is inactive

		if ( bp_is_active( 'friends' ) ) {
			$count = 0;

			$bpCoreGetUsers = bp_core_get_users( array(
				'type'    => $byType,
				'user_id' => $userId,
			) );

			if ( ! empty( $bpCoreGetUsers ) && isset( $bpCoreGetUsers['total'] ) ) {
				$count = $bpCoreGetUsers['total'];
			}
		}

		return $count;
	}
}

// @todo : Add proper description here
if ( ! function_exists( 'get_bp_total_groups' ) ) {
	function get_bp_total_groups( $byType = 'alphabetical' ) {

		$count  = - 1; //if buddypress group component is inactive
		$groups = array();

		if ( bp_is_active( 'groups' ) ) {
			$count = 0;

			if ( groups_get_groups() ) {
				$args = array( 'type' => $byType );
				if ( bp_current_user_can( 'bp_moderate' ) ) {
					$args['show_hidden'] = true;
				}
				$groups = groups_get_groups( $args );
			}

			if ( ! empty( $groups ) && isset( $groups['total'] ) ) {
				$count = $groups['total'];
			}
		}

		return $count;

	}
}

// @todo : Add proper description here
if ( ! function_exists( 'get_bp_total_groups_for_user' ) ) {
	function get_bp_total_groups_for_user( $byType = 'alphabetical', $forUserId = 0 ) {

		$count  = - 1; //if buddypress group component is inactive
		$groups = array();

		if ( bp_is_active( 'groups' ) ) {
			$count = 0;

			if ( groups_get_groups() ) {
				$groups = groups_get_groups( array(
					'type'        => $byType,
					'user_id'     => $forUserId,
					'show_hidden' => true
				) );
			}

			if ( ! empty( $groups ) && isset( $groups['total'] ) ) {
				$count = $groups['total'];
			}
		}

		return $count;

	}
}

/**
 * Overriding buddypress's default behavior
 *
 * @param string $context Optional.
 *
 * @return array the filters
 * @see bp_nouveau_get_members_filters() in bp-templates/bp-nouveau/includes/members/functions.php
 *
 */
if ( ! function_exists( 'bbapp_bp_nouveau_get_members_filters' ) ) {
	function bbapp_bp_nouveau_get_members_filters( $context = '' ) {
		if ( 'group' !== $context ) {
			if ( bp_is_active( 'xprofile' ) ) {
				$filters['alphabetical'] = __( 'Alphabetical', 'buddypress' );
			}

			$filters['active'] = __( 'Last Active', 'buddypress' );
			$filters['newest'] = __( 'Newest Registered', 'buddypress' );

			$action = 'bp_members_directory_order_options';

			if ( 'friends' === $context ) {
				$action = 'bp_member_friends_order_options';
			}
		} else {

			$filters = array(
				'alphabetical' => __( 'Alphabetical', 'buddypress' ),
				'last_joined'  => __( 'Newest', 'buddypress' ),
				'first_joined' => __( 'Oldest', 'buddypress' ),
			);

			if ( bp_is_active( 'activity' ) ) {
				$filters['group_activity'] = __( 'Group Activity', 'buddypress' );
			}

			$action = 'bp_groups_members_order_options';
		}

		return bp_nouveau_parse_hooked_options( $action, $filters );
	}
}
