<?php
namespace BuddyBossApp\Api\BuddyPress;
use WP_REST_Controller;

defined('ABSPATH') || exit;

// NOTE : Old classname was class.boss_buddypress_api_profile_search_rest_api. By Ketan, Oct-2019
// Endpoints for BuddyBoss Members Component
class ProfileSearchRestApi extends WP_REST_Controller {

	protected $namespace_slug = '';
	protected $namespace = '/buddypress/v1';

	public function __construct($slug) {
		/** Nothing here */
		$this->namespace_slug = $slug;
		$this->namespace = $this->namespace_slug . $this->namespace;
		$this->rest_base = buddypress()->members->id;
		// @todo : Verify below line of code
		$this->rest_base = 'members';
	}

	public function hooks() {
		add_filter('boss_rest_buddypress_members_args', array($this, 'bps_boss_filter_members'), 99);
	}

	public function bps_boss_filter_members($args) {
		$request = bps_get_request('search');
		if (empty($request)) {
			return $args;
		}
		$results = bps_search($request);
		if ($results['validated']) {
			$users = $results['users'];
			if (!empty($args['include'])) {
				$included = explode(',', $args['include']);
				$users = array_intersect($users, $included);
				if (count($users) == 0) {
					$users = array(0);
				}
			}
			$users = apply_filters('bps_search_results', $users);
			$args['include'] = implode(',', $users);
		}
		return $args;
	}
}
