<?php
namespace BuddyBossApp\Api\BuddyPress;
use WP_REST_Controller;

defined('ABSPATH') || exit;
// NOTE : Old classname was class.boss_buddypress_api_members_location_rest_api. By Ketan, Oct-2019
// Endpoint for BuddyBoss Members Component
class MembersLocationRestApi extends WP_REST_Controller {

	protected $namespace_slug = '';
	protected $namespace = '/buddypress/v1';

	public function __construct($slug) {
		/** Nothing here */
		$this->namespace_slug = $slug;
		$this->namespace = $this->namespace_slug . $this->namespace;
		$this->rest_base = buddypress()->members->id;
		// @todo : Verify below line of code
		$this->rest_base = 'members';
	}

	public function hooks() {
		add_action('boss_rest_buddypress_member_item', array($this, 'update_member_data'));
	}

	public function update_member_data($data) {
		$data['location'] = $this->get_user_location($data['id']);
		return $data;
	}

	private function get_user_location($user_id) {
		if (!function_exists('bp_bpla')) {
			return false;
		}

		if (!bp_is_active('xprofile')) {
			return false;
		}

		if ('yes' != bp_bpla()->option('enable-for-profiles')) {
			return false;
		}

		if ('single' == bp_bpla()->option('location-field-address-selection')) {
			$location_field_address = $this->_get_xpfield_id(bp_bpla()->option('location-field-address'));
			$address = xprofile_get_field_data($location_field_address, $user_id);
		} else {
			$street = '';
			$xp_field = $this->_get_xpfield_id(bp_bpla()->option('location-field-street'));
			if (!empty($xp_field)) {
				$street = xprofile_get_field_data($xp_field, $user_id);
				$street = !empty($street) ? $street . ', ' : '';
			}

			$city = '';
			$xp_field = $this->_get_xpfield_id(bp_bpla()->option('location-field-city'));
			if (!empty($xp_field)) {
				$city = xprofile_get_field_data($xp_field, $user_id);
				$city = !empty($city) ? $city . ', ' : '';
			}

			$state = '';
			$xp_field = $this->_get_xpfield_id(bp_bpla()->option('location-field-state'));
			if (!empty($xp_field)) {
				$state = xprofile_get_field_data($xp_field, $user_id);
				$state = !empty($state) ? $state . ', ' : '';
			}

			$zip = '';
			$xp_field = $this->_get_xpfield_id(bp_bpla()->option('location-field-zipcode'));
			if (!empty($xp_field)) {
				$zip = xprofile_get_field_data($xp_field, $user_id);
				$zip = !empty($zip) ? $zip . ', ' : '';
			}

			$country = '';
			$xp_field = $this->_get_xpfield_id(bp_bpla()->option('location-field-country'));
			if (!empty($xp_field)) {
				$country = xprofile_get_field_data($xp_field, $user_id);
			}

			$address = $street . $city . $state . $zip . $country;
			$address = rtrim($address);
			$address = rtrim($address, ',');

		}

		return $address;
	}

	private function _get_xpfield_id($field_id) {
		/**
		 * if field_id is like field_3
		 * return only 3
		 */
		return str_replace('field_', '', $field_id);
	}
}
