<?php
namespace BuddyBossApp\Api\BuddyPress;
use WP_REST_Controller;
use WP_REST_Request;

defined('ABSPATH') || exit;
// NOTE : Old classname was class.boss_buddypress_api_members_follow_rest_api. By Ketan, Oct-2019
// Endpoint for BuddyBoss Members Component
class MembersFollowRestApi extends WP_REST_Controller {

	protected $namespace_slug = '';
	protected $namespace = '/buddypress/v1';

	public function __construct($slug) {
		/** Nothing here */
		$this->namespace_slug = $slug;
		$this->namespace = $this->namespace_slug . $this->namespace;
		$this->rest_base = buddypress()->members->id;
		// @todo : Verify below line of code
		$this->rest_base = 'members';
	}

	public function hooks() {

		/**
		 * Members
		 */
		add_filter('boss_rest_buddypress_members_args', array($this, 'filter_by_scope'), 10, 2);
		add_action('boss_rest_buddypress_members_action_args', array($this, 'update_action_args'));
		add_action('boss_rest_buddypress_member_item', array($this, 'update_member_data'));
		add_action('boss_rest_buddypress_members_action', array($this, 'do_action'));

		/**
		 * Activity
		 */
		add_filter('boss_rest_buddypress_activity_args', array($this, 'activity_filter_by_scope'), 10, 2);
	}

	/**
	 *
	 * @param array $args
	 * @param WP_REST_Request $request
	 * @return array
	 */
	public function filter_by_scope($args, $request) {
		$user_id = $request->get_param('user_id');
		$user_id = !empty($user_id) ? $user_id : bp_loggedin_user_id();

		if ($request->get_param('scope') == 'following') {
			if (empty($args['include'])) {
				$following_ids = $this->_bp_get_following_ids(array('user_id' => $user_id));

				// if $following_ids is empty, pass a negative number so no activity can be found
				$following_ids = empty($following_ids) ? -1 : $following_ids;

				$args['include'] = $following_ids;
				unset($args['user_id']);
			}
		} else if ($request->get_param('scope') == 'followers') {
			if (empty($args['include'])) {
				$followers_ids = $this->_bp_get_follower_ids(array('user_id' => $user_id));

				// if $following_ids is empty, pass a negative number so no activity can be found
				$followers_ids = empty($followers_ids) ? -1 : $followers_ids;

				$args['include'] = $followers_ids;
				unset($args['user_id']);
			}
		}

		return $args;
	}

	public function update_action_args($args) {
		$args['action']['enum'] = array_merge($args['action']['enum'], array('follow', 'unfollow'));
		return $args;
	}

	public function update_member_data($data) {
		$follower_counts = $this->_bp_follow_total_follow_counts(array('user_id' => $data['id']));
		$data['followers'] = (int) $follower_counts['followers'];
		$data['following'] = (int) $follower_counts['following'];

		if (!bp_loggedin_user_id()) {
			return $data;
		}

		if ($data['id'] != bp_loggedin_user_id()) {
			if ($this->_bp_follow_is_following(array('leader_id' => $data['id'], 'follower_id' => bp_loggedin_user_id()))) {
				$data['is_following'] = true;
			} else {
				$data['is_following'] = false;
			}
		}

		return $data;
	}

	public function do_action($request) {
		$me_id = bp_loggedin_user_id();
		$member_id = (int) $request['id'];
		$action = $request['action'];

		switch ($action) {
		case 'follow':
			if (!$this->_bp_follow_is_following(array('leader_id' => $member_id, 'follower_id' => $me_id))) {
                $this->_bp_follow_start_following(array('leader_id' => $member_id, 'follower_id' => $me_id));
				return true;
			}
			break;
		case 'unfollow':
			if ($this->_bp_follow_is_following(array('leader_id' => $member_id, 'follower_id' => $me_id))) {
                $this->_bp_follow_stop_following(array('leader_id' => $member_id, 'follower_id' => $me_id));
				return true;
			}
			break;
		}
		return false;
	}

	public function activity_filter_by_scope($args, $request) {
		$user_id = $request->get_param('user_id');
		$user_id = !empty($user_id) ? $user_id : bp_loggedin_user_id();

		if ($request->get_param('scope') == 'following') {
			if (empty($args['include'])) {
				$following_ids = $this->_bp_get_following_ids(array('user_id' => $user_id));

				// if $following_ids is empty, pass a negative number so no activity can be found
				$following_ids = empty($following_ids) ? -1 : $following_ids;

				$args['user_id'] = $following_ids;
			}
		}

		return $args;
	}

    /**
     * Switching function according to active plugin
     * @param $args
     * @return mixed
     */
	private function _bp_get_following_ids( $args ){
        if (bp_is_active("follow")) {
	        return bp_get_following_ids( $args );
        } else {
            return bp_get_following( $args );
        }
    }

    /**
     * Switching function according to active plugin
     * @param $args
     * @return mixed
     */
    private function _bp_get_follower_ids( $args ){
        if (bp_is_active("follow")) {
            return bp_get_follower_ids( $args );
        } else {
            return bp_get_followers( $args );
        }
    }

    /**
     * Switching function according to active plugin
     * @param $args
     * @return mixed
     */
    private function _bp_follow_total_follow_counts( $args ){
        if (bp_is_active("follow")) {
            return bp_follow_total_follow_counts( $args );
        } else {
            return bp_total_follow_counts( $args );
        }
    }

    /**
     * Switching function according to active plugin
     * @param $args
     * @return mixed
     */
    private function _bp_follow_is_following( $args ){
        if (bp_is_active("follow")) {
            return bp_follow_is_following( $args );
        } else {
            return bp_is_following( $args );
        }
    }

    /**
     * Switching function according to active plugin
     * @param $args
     * @return mixed
     */
    private function _bp_follow_start_following( $args ){
        if (bp_is_active("follow")) {
            return bp_follow_start_following( $args );
        } else {
            return bp_start_following( $args );
        }
    }

    /**
     * Switching function according to active plugin
     * @param $args
     * @return mixed
     */
    private function _bp_follow_stop_following( $args ){
        if (bp_is_active("follow")) {
            return bp_follow_stop_following( $args );
        } else {
            return bp_stop_following( $args );
        }
    }

}
