<?php
namespace BuddyBossApp\Api\BuddyPress;
use BuddyBossApp\Api\BuddyPress\AccountSettingsRestApi;
use BuddyBossApp\Api\BuddyPress\ActivityCommentRestApi;
use BuddyBossApp\Api\BuddyPress\ActivityRestApi;
use BuddyBossApp\Api\BuddyPress\CoreRestApi;
use BuddyBossApp\Api\BuddyPress\FriendsRestApi;
use BuddyBossApp\Api\BuddyPress\GroupsCreateRestApi;
use BuddyBossApp\Api\BuddyPress\GroupsInviteRestApi;
use BuddyBossApp\Api\BuddyPress\GroupsManageRestApi;
use BuddyBossApp\Api\BuddyPress\GroupsRestApi;
use BuddyBossApp\Api\BuddyPress\MembersFollowRestApi;
use BuddyBossApp\Api\BuddyPress\MembersLocationRestApi;
use BuddyBossApp\Api\BuddyPress\MembersRestApi;
use BuddyBossApp\Api\BuddyPress\MessagesRestApi;
use BuddyBossApp\Api\BuddyPress\NotificationsRestApi;
use BuddyBossApp\Api\BuddyPress\ProfileSearchRestApi;
use BuddyBossApp\Api\BuddyPress\XprofileRestApi;

// @todo - This need to have namespace and PSR-4 standards. By Ketan, Apr-2019
class Main {

	private $namespace_slug = 'appboss';

	public function __construct() {
		//register all hooks.
		$this->hooks();
	}

	/**
	 * Register all hooks
	 * @since 1.0.0
	 * @return void
	 */
	public function hooks() {
		add_action('bp_init', array($this, "load_rest"));
	}

	public function load_rest() {

		include dirname( __FILE__ ) . '/functions.php';

		if (!function_exists('bp_is_active')) {
			// don't load if buddypress is not enabled.
			return false;
		}

		include dirname( __FILE__ ) . '/filters-n-actions.php';

		// Load REST API Functionality
		$boss_rest_bp_core = new CoreRestApi($this->namespace_slug);
		$boss_rest_bp_core->hooks();

		/**
		 * Register BuddyPress Xprofile Rest Endpoint
		 */
		if (bp_is_active("xprofile")) {
			$boss_rest_bp_xprofile = new XprofileRestApi($this->namespace_slug);
			$boss_rest_bp_xprofile->hooks();
		}

		/**
		 * Register BuddyPress Groups Rest Endpoint
		 */
		if (bp_is_active("groups")) {
			$boss_rest_bp_group = new GroupsRestApi($this->namespace_slug);
			$boss_rest_bp_group->hooks();

			$boss_rest_bp_group_manage = new GroupsManageRestApi($this->namespace_slug);
			$boss_rest_bp_group_manage->hooks();

			$boss_rest_bp_group_create = new GroupsCreateRestApi($this->namespace_slug);
			$boss_rest_bp_group_create->hooks();

			$boss_rest_bp_group_invite = new GroupsInviteRestApi($this->namespace_slug);
			$boss_rest_bp_group_invite->hooks();
		}

		/**
		 * Register BuddyPress Members Rest Endpoint
		 */
		if (bp_is_active("members")) {
			$boss_rest_bp_members = new MembersRestApi($this->namespace_slug);
			$boss_rest_bp_members->hooks();
		}

		/**
		 * Register BuddyPress Member follow Rest Endpoint
		 */
		if (bp_is_active("follow") || ( ( function_exists('bp_is_active') && bp_is_active('activity') &&
                function_exists('bp_is_activity_follow_active') && bp_is_activity_follow_active() ) ) ) {
			$boss_rest_bp_members_follow = new MembersFollowRestApi($this->namespace_slug);
			$boss_rest_bp_members_follow->hooks();
		}

		/**
		 * Register BuddyPress Member location Rest Endpoint
		 */
		if (class_exists("BuddyBoss_BPLA_Plugin")) {
			$boss_rest_bp_members_location = new MembersLocationRestApi($this->namespace_slug);
			$boss_rest_bp_members_location->hooks();
		}

		/**
		 * Register BuddyPress Profile search Rest Endpoint
		 */
		if (bp_is_active("members") && defined('BPS_FORM')) {
			$boss_rest_bp_members_location = new ProfileSearchRestApi($this->namespace_slug);
			$boss_rest_bp_members_location->hooks();
		}

		/**
		 * Register BuddyPress Friends Rest Endpoint
		 */
		if (bp_is_active("friends")) {
			$boss_rest_bp_friend = new FriendsRestApi($this->namespace_slug);
			$boss_rest_bp_friend->hooks();
		}

		/**
		 * Register BuddyPress Messages Rest Endpoint
		 */
		if (bp_is_active("messages")) {
			$boss_rest_bp_message = new MessagesRestApi($this->namespace_slug);
			$boss_rest_bp_message->hooks();
		}

		/**
		 * Register BuddyPress Activity Rest Endpoint
		 */
		if (bp_is_active("activity")) {
			$boss_rest_bp_activity = new ActivityRestApi($this->namespace_slug);
			$boss_rest_bp_activity->hooks();
			$boss_rest_bp_activity_comment = new ActivityCommentRestApi($this->namespace_slug);
			$boss_rest_bp_activity_comment->hooks();
		}

		/**
		 * Register BuddyPress Settings Rest Endpoint
		 */
		if (bp_is_active("settings")) {
			$boss_rest_bp_setting = new AccountSettingsRestApi($this->namespace_slug);
			$boss_rest_bp_setting->hooks();
		}

		/**
		 * Register BuddyPress Notification Rest Endpoint
		 */
		if (bp_is_active("notifications")) {
//			$boss_rest_bp_notification = new NotificationsRestApi($this->namespace_slug);
//			$boss_rest_bp_notification->hooks();
            new NotificationsRestApi();
		}

	}
}
