<?php
namespace BuddyBossApp\Api\BuddyPress;
use WP_Error;
use WP_REST_Controller;
use WP_REST_Response;
use WP_REST_Server;

// NOTE : Old classname was class.boss_buddypress_api_core_rest_api. By Ketan, Oct-2019
class CoreRestApi extends WP_REST_Controller {

	protected $namespace_slug = '';
	protected $namespace = '/buddypress/v1';

	public function __construct($slug) {
		/** Nothing here */
		$this->namespace_slug = $slug;
		$this->namespace = $this->namespace_slug . $this->namespace;
	}

	public function hooks() {

		add_action('rest_api_init', array($this, "register_routes"), 99);
		add_filter('bbapp_rest_search_tab', array($this, 'add_search_tabs'));

	}


	/**
	 * Add a require search tab into app.
	 * @param $tabs
	 * @return array
	 */
	public function add_search_tabs($tabs) {
		if (bp_is_active("groups")) {
			$bp_tabs[] = array(
				'id' => 'groups',
				'title' => __('Groups', 'buddyboss-app'),
			);
		}

		if (bp_is_active("members")) {
			$bp_tabs[] = array(
				'id' => 'members',
				'title' => __('Members', 'buddyboss-app'),
			);
		}

		return array_merge($tabs, $bp_tabs);
	}

	/**
	 * register_routes function.
	 *
	 * Register the routes for the objects of the controller.
	 *
	 * @access public
	 * @return void
	 */
	public function register_routes() {
		register_rest_route($this->namespace, '/core/*', array(
			'methods' => WP_REST_Server::READABLE,
			'callback' => array($this, 'get_item'),
			'permission_callback' => array($this, 'core_api_permissions'),
		));

		register_rest_route($this->namespace, '/core/settings', array(
			'methods' => WP_REST_Server::READABLE,
			'callback' => array($this, 'get_settings'),
			'permission_callback' => array($this, 'core_api_permissions'),
		));
	}

	/**
	 * @param $request
	 * @return array|WP_Error
	 * @api {GET} /wp-json/appboss/buddypress/v1/core/settings Core settings
	 * @apiName GetBpCoreSettings
	 * @apiGroup BuddyPressCore
	 * @apiVersion 1.0.0
	 * @apiPermission LoggedInUser
	 * @apiDescription Core settings (Includes Main, Profile, Groups and Activity settings)
	 * @apiDeprecated  Retrieve settings. Check (#Settings:GetBBSettings)
	 * @apiUse apidocForGetBpCoreSettingsV1
	 * @apiPrivate
	 */
	public function get_settings($request) {

		if (!is_user_logged_in()) {
			return new WP_Error('rest_not_logged_in', __('You are not currently logged in.'), array('status' => rest_authorization_required_code() ));
		}

		return array(
			'Main Settings' => array(
				'bp_disable_account_deletion' => bp_disable_account_deletion(false),
			),
			'Profile Settings' => array(
				'bp_disable_avatar_uploads' => bp_disable_avatar_uploads(false),
				'bp_disable_cover_image_uploads' => bp_disable_cover_image_uploads(),
			),
			'Groups Settings' => array(
				'bp_restrict_group_creation' => bp_restrict_group_creation(false),
				'bp_disable_group_avatar_uploads' => bp_disable_group_avatar_uploads(),
				'bp_disable_group_cover_image_uploads' => bp_disable_group_cover_image_uploads(),
			),
			'Activity Settings' => array(
				'bp_disable_blogforum_comments' => bp_disable_blogforum_comments(false),
			),
		);
	}

	/**
	 * @param $request
	 * @return WP_REST_Response|WP_Error
	 * @api {GET} /wp-json/appboss/buddypress/v1/core  Core item
	 * @apiName GetBpCoreItem
	 * @apiGroup BuddyPressCore
	 * @apiVersion 1.0.0
	 * @apiPermission LoggedInUser
	 * @apiDescription Get BP core item
	 * @apiDeprecated  Retrieve components. Check (#Components:GetBBComponents)
	 * @apiUse apidocForGetBpCoreItemV1
	 * @apiPrivate
	 */
	public function get_item($request) {

		if (!is_user_logged_in()) {
			return new WP_Error('rest_not_logged_in', __('You are not currently logged in.'), array('status' => rest_authorization_required_code() ));
		}

		global $bp;
		$core = array(
			'version' => $bp->version,
			'active_components' => $bp->active_components,
		);

		$core = apply_filters('core_api_data_filter', $core);

		$response = new WP_REST_Response();
		$response->set_data($core);
		$response = rest_ensure_response($response);

		return $response;
	}

	public function core_api_permissions() {
		return apply_filters('boss_rest_buddypress_core_permissions', true);
	}

}
