<?php
namespace BuddyBossApp\Api\BbPress;
// NOTE : Old classname was class.boss_bbpress_api_use_api By Ketan, Oct-2019
// (v1 Standard) Contain functionality for required additional rest api endpoints for bbpress.
class UserApi {

	public function __construct() {
		/** Nothing here */
		$this->hooks();
	}

	public function hooks() {
		add_filter('rest_user_query', array($this, 'filter_contributors'), 10, 2);
	}

	public function filter_contributors($prepared_args, $request) {
		global $wpdb;

		if ($request['contributors'] == '1') {

			$limit = $request['page'] * $prepared_args['number'];

			$query = "SELECT u.post_author as post_author, COUNT(*) as count
							  FROM " . $wpdb->prefix . "posts u
							  WHERE (post_type ='reply' OR post_type = 'topic') and post_status = 'publish'
							  AND u.post_author IN (SELECT ID FROM  {$wpdb->prefix}users WHERE ID=u.post_author)
							  GROUP BY post_author
							  ORDER BY count DESC
							  LIMIT $limit";

			$result = $wpdb->get_results($query);

			$user_ids = array();
			if (!empty($result)) {
				foreach ($result as $r) {
					$user_ids[] = $r->post_author;
				}
			}

			if (!empty($user_ids)) {
				$prepared_args['include'] = $user_ids;
			} else {
				$prepared_args['include'] = array(0);
			}

			$prepared_args['orderby'] = 'include';
			$prepared_args['order'] = 'asc';

		}

		return $prepared_args;
	}

}