<?php
namespace BuddyBossApp\Api\BbPress;
// NOTE : Old classname was class.boss_bbpress_api_multisite_bug. By Ketan, Oct-2019
// Make sure we don't expose any info if called directly
class MultisiteBug {

	public function __construct() {
		$this->hooks();
	}

	public function hooks() {
		add_action('after_setup_theme', array($this, 'plugins_loaded'));
	}

	function plugins_loaded() {
		add_filter('bbp_allow_global_access', array($this, 'allow_global_access'));
	}

	/**
	 * Prevent to add user automatically in site by bbpress while REST request.
	 *
	 * @param $enabled
	 *
	 * @return bool
	 */
	public function allow_global_access($enabled) {
		if (strpos($_SERVER['REQUEST_URI'], 'wp-json/') !== false) {
			$enabled = false;
		}
		return $enabled;
	}
}
