<?php
namespace BuddyBossApp\Api\BbPress;

// @todo - This need to have namespace and PSR-4 standards. By Ketan, Apr-2019

use BuddyBossApp\Api\BbPress\Bug;
use BuddyBossApp\Api\BbPress\ForumRest;
use BuddyBossApp\Api\BbPress\MultisiteBug;
use BuddyBossApp\Api\BbPress\ReplyRest;
use BuddyBossApp\Api\BbPress\RestApi;
use BuddyBossApp\Api\BbPress\SearchApi;
use BuddyBossApp\Api\BbPress\TopicRest;
use BuddyBossApp\Api\BbPress\UserApi;

class Main {

	private $namespace_slug = 'appboss';

	public function __construct() {
		//register all hooks.
		$this->hooks();
	}

	/**
	 * Register all hooks
	 * @since 1.0,0
	 * @return void
	 */
	public function hooks() {
		add_action('init', array($this, "load_rest"));
		add_action('init', array($this, 'init'), 99);

		new MultisiteBug();
	}

	public function load_rest() {

		/**
		 * One of bbPress or BuddyBoss Platform with bbPress should be available.
		 */
		if (!class_exists('bbPress') AND !(function_exists('bp_is_active') && bp_is_active('forums') && isset(buddypress()->buddyboss))) {
			// don't load if bbpress is not enabled.
			return false;
		}
		require_once dirname( __FILE__ ) . '/functions.php';

		// Load REST API Functionality
		new RestApi($this->namespace_slug);
		
		// First check if the forum/topic/reply post type is registered 
		if (post_type_exists('forum')) {
			new ForumRest($this->namespace_slug);
		}
		if (post_type_exists('topic')) {
			new TopicRest($this->namespace_slug);
		}
		if (post_type_exists('reply')) {
			new ReplyRest($this->namespace_slug);
		}
		new SearchApi($this->namespace_slug);
		new UserApi();
		new Bug();

	}

	public function init() {
		// adding post type thumbnail support for forums
		add_post_type_support('forum', array('thumbnail'));
	}

}
