<?php
namespace BuddyBossApp\Api\BbPress;
use WP_Query;

defined('ABSPATH') || exit;

// NOTE - Old classname : class.boss_bbpress_api_bug. By Ketan, Oct-2019
class Bug {

	public function __construct() {
		$this->hooks();
	}

	public function hooks() {
		add_filter("bbp_get_hidden_forum_ids", array($this, "update_hidden_forum_ids"), 10, 3);
	}

	public function update_hidden_forum_ids($forum_ids) {
		$new_hash = md5(implode(',', $forum_ids));
		$saved_hash = get_option('_boss_bbpress_hidden_froms_hash', '');
		if ($new_hash !== $saved_hash) {
			delete_option('_bbp_hidden_forums');
			remove_action('pre_get_posts', 'bbp_pre_get_posts_normalize_forum_visibility', 4);
			$hidden_forums = new WP_Query(array(
				'suppress_filters' => true,
				'nopaging' => true,
				'post_type' => bbp_get_forum_post_type(),
				'post_status' => bbp_get_hidden_status_id(),
				'fields' => 'ids',
			));
			add_action('pre_get_posts', 'bbp_pre_get_posts_normalize_forum_visibility', 4);

			// Reset the $post global
			wp_reset_postdata();

			// Bail if queries returned errors
			if (is_wp_error($hidden_forums)) {
				return false;
			}

			update_option('_bbp_hidden_forums', $hidden_forums->posts); // Hidden forums
			update_option('_boss_bbpress_hidden_froms_hash', $new_hash, true); // Hidden forums
			$forum_ids = $hidden_forums->posts;
		}
		return $forum_ids;
	}
}
