<?php
namespace BuddyBossApp\Api\BbPress;
// Note : The soul purpose of this class is apidoc(documentation generator). By Ketan
class ApidocV1 {

	private function apidocAdditionalForBBpressPostsV1() {
		/**
		 * @apiDefine apidocAdditionalForBBpressPostsV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String} menu_order The order of the object in relation to other object of its type.
		 * @apiParam {Number{1-∞}} [page=1] Current page of the collection.
		 * @apiParam {Number{1-100}} [per_page=10] Maximum number of items to be returned in result set.
		 * @apiParam {Number{1-100}} [per_page=10] Maximum number of items to be returned in result set.
		 * @apiParam {String} [after] Limit response to resources published after a given ISO8601 compliant date.
		 * @apiParam {String} [before] Limit response to resources published before a given ISO8601 compliant date.
		 * @apiParam {Array} [author=array()] Limit result set to posts assigned to specific authors.(Backend WP_Query: author__in)
		 * @apiParam {Array} [author_exclude=array()] Ensure result set excludes posts assigned to specific authors.(Backend WP_Query: author__not_in)
		 * @apiParam {Array} [exclude=array()] Ensure result set excludes specific ids.(Backend WP_Query: post__not_in)
		 * @apiParam {Array} [include=array()] Limit result set to specific ids.(Backend WP_Query: post__in)
		 * @apiParam {Number} offset Offset the result set by a specific number of items.
		 * @apiParam {String=desc,asc} [order=desc] Order sort attribute ascending or descending.(Backend WP_Query: order)
		 * @apiParam {String=date,id,include,title,slug,trending,default,activity,popular,items,parent} [orderby=date] Sort collection by object attribute.(Backend WP_Query: orderby)
		 * @apiParam {String=day,week,month,year} [trending=year] Sort collection by object trending attribute.
		 * @apiParam {String} [slug] Limit result set to posts with a specific slug.(Backend WP_Query: post_name__in)
		 * @apiParam {String} [status=publish] Limit result set to posts assigned a specific status.
		 * @apiError {Object}  Response object
		 */
	}

	private function apidocAdditionalForBBpressForumV1() {
		/**
		 * @apiDefine apidocAdditionalForBBpressForumV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} id identifier of forum
		 */
	}

	private function apidocAdditionalForBBpressReplyV1() {
		/**
		 * @apiDefine apidocAdditionalForBBpressReplyV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} id identifier of `reply`
		 */
	}

	private function apidocAdditionalForBBpressTopicV1() {
		/**
		 * @apiDefine apidocAdditionalForBBpressTopicV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} id identifier of `topic`
		 */
	}

	private function apidocForBBPressReplyV1() {
		/**
		 * @apiDefine apidocForBBPressReplyV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} topic_id Topic Id of `reply`
		 * @apiParam {String} content Content of `reply`
		 * @apiParam {Number} [forum_id] Forum Id of `reply`
		 * @apiParam {Number} [group_id] Group Id
		 * @apiParam {String} [title] Title of `reply`
		 * @apiParam {Number} [reply_to] Reply to
		 * @apiParam {String} [tags=""] Tags name of `reply`
		 * @apiParam {String} [type=""] Type of `reply`
		 * @apiParam {String} [reason=""] Reason of `reply` edit
		 * @apiParam {String} [log=""] Log of `reply` edit
		 * @apiParam {Boolean} [subscribe] Whether user subscribe reply or no.
		 */

	}

	private function apidocForBBPressPostsV1() {
		/**
		 * @apiDefine apidocForBBPressPostsV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {String} search Limit results to those matching a string.
		 * @apiParam {String} menu_order Limit result set to resources with a specific menu_order value.
		 * @apiParam {String} _embed //todo : Add description
		 * @apiParam {String} [slug] Limit result set to posts with a specific slug.(Backend WP_Query: post_name__in)
		 * @apiParam {Number{1-∞}} [page=1] Particular page for pagination
		 * @apiParam {Array} [author=array()] Limit result set to posts assigned to specific authors.
		 * @apiParam {Array} [author_exclude=array()] Ensure result set excludes posts assigned to specific authors.
		 * @apiParam {Array} [include=array()] Limit result set to specific ids.
		 * @apiParam {Array} [exclude=array()] Ensure result set excludes specific ids.
		 * @apiParam {Number} [per_page] Maximum number of items to be returned in result set.-1 for all
		 * @apiParam {Number} [offset] Offset the result set by a specific number of items.
		 * @apiParam {String=asc,desc} [order=desc] Order sort attribute ascending or descending.
		 * @apiParam {String=date,id,include,title,slug,trending,default,activity,popular,items,parent} [orderby=date] Sort collection by object attribute.
		 * @apiParam {String} [status=publish] Limit result set to posts assigned a specific status.
		 * @apiParam {Array} [parent=array()] Limit result set to those of particular parent ids.(Backend WP_Query: post_parent__in)
		 * @apiParam {Array} [parent_exclude=array()] Limit result set to all items except those of a particular parent id.(Backend WP_Query: post_parent__not_in)
		 * @apiError {Object}  Response object
		 */
	}

	private function apidocForBBPressTopicV1() {
		/**
		 * @apiDefine apidocForBBPressTopicV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} parent Parent id of `topic`
		 * @apiParam {Number} group_id Id of group
		 * @apiParam {String} title Title of `topic`
		 * @apiParam {String} status Status of `topic`
		 * @apiParam {String} tags Tags name of `topic`
		 * @apiParam {String} type Type of `topic`
		 * @apiParam {String} content Content of `topic`
		 * @apiParam {String} reason Reason of `topic` edit
		 * @apiParam {String} log Log of `topic` edit
		 * @apiParam {String} subscribe Whether user subscribed to `topic` or no
		 */
	}

	private function apidocForMergeTopicV1() {
		/**
		 * @apiDefine apidocForMergeTopicV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} bbp_topic_id Id of `topic`
		 * @apiParam {Number} bbp_destination_topic Id of destination `topic`
		 * @apiParam {Number} bbp_topic_subscribers Whether `topic` is subscribed or not.
		 * @apiParam {Number} bbp_topic_favoriters Whether `topic` is favourite or not.
		 * @apiParam {Number} bbp_topic_tags Whether `topic` is favourite or not.
		 */
	}

	private function apidocForSplitTopicV1() {
		/**
		 * @apiDefine apidocForSplitTopicV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} bbp_reply_id Id of `topic`
		 * @apiParam {Number} bbp_destination_topic Id of destination `topic`
		 * @apiParam {String=existing,reply} bbp_topic_split_option Option of split `topic`
		 * @apiParam {String} bbp_topic_split_destination_title Title of destination `topic`
		 * @apiParam {Number} bbp_topic_subscribers Whether `topic` is subscribed or not.
		 * @apiParam {Number} bbp_topic_favoriters Whether `topic` is favourite or not.
		 * @apiParam {Number} bbp_topic_tags Whether `topic` has tag or not.
		 */
	}

	private function apidocForUpdateTopicActionV1() {
		/**
		 * @apiDefine apidocForUpdateTopicActionV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number=1,0} favourite //TODO : Add description
		 * @apiParam {Number=1,0} subscribe //TODO : Add description
		 * @apiParam {Number=1,0} close //TODO : Add description
		 * @apiParam {Number=1,0} stick //TODO : Add description
		 * @apiParam {Number=1,0} is_super //TODO : Add description
		 * @apiParam {Number=1,0} spam //TODO : Add description
		 * @apiParam {Number=1,0} trash //TODO : Add description
		 * @apiParam {Number=1,0} delete //TODO : Add description
		 */

	}

	private function apidocForReplyActionV1() {
		/**
		 * @apiDefine apidocForReplyActionV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} id Reply(`reply`) ID
		 * @apiParam {Number=1,0} [spam] Mark this `reply` as spam
		 * @apiParam {Number=1,0} [trash] Mark this `reply` as trash
		 * @apiParam {Number=1,0} [delete] Mark this `reply` as delete
		 */
	}

	private function apidocForMoveBBPressReplyV1() {
		/**
		 * @apiDefine apidocForMoveBBPressReplyV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} bbp_reply_id Id(`reply` ID to move) of `reply`
		 * @apiParam {Number} bbp_destination_topic Id(destination `topic` ID) of destination `reply`
		 * @apiParam {String="existing","topic"} bbp_reply_move_option Option(valid move option) of move `reply`
		 * @apiParam {String} [bbp_reply_move_destination_title] Title of destination `reply`
		 * @apiParam {String} [action] The requested action to compare this function to
		 */
	}

	private function apidocForBBPressSettingsV1() {
		/**
		 * @apiDefine apidocForBBPressSettingsV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} bbp_reply_id Id of `reply`
		 * @apiParam {Number} bbp_destination_topic Id of destination `reply`
		 * @apiParam {Number} bbp_reply_move_option Option of move `reply`
		 * @apiParam {Number} bbp_reply_move_destination_title Title of destination `reply`
		 * @apiParam {String} action The requested action to compare this function to
		 */
	}

	private function apidocForForumActionV1() {
		/**
		 * @apiDefine apidocForForumActionV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} id Forum Id
		 * @apiParam {Number=1,0} subscribe Perform subscribe-action
		 */
	}

	private function apidocForForumDropdownV1() {
		/**
		 * @apiDefine apidocForForumDropdownV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam  {Number} [page=1] Current page of the collection.
		 * @apiParam {Number} [per_page=-1] Maximum number of items to be returned in result set. -1 for all
		 */
	}

	private function apidocGetSubForumsV1() {
		/**
		 * @apiDefine apidocGetSubForumsV1
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} id Forum ID
		 * @apiParam  {Number{1-∞}} [page=1] Current page of the collection.
		 * @apiParam {Number} [per_page=-1] Maximum number of items to be returned in result set. -1 for all
		 */
	}

	private function apidocForBBPressDeleteTopicV1() {
		/**
		 * @apiDefine apidocForBBPressDeleteTopic
		 *
		 * @apiHeader {String} accessToken Auth token
		 * @apiParam {Number} id identifier of `reply`
		 */
	}

}