<?php
/**
 * DeepLinking Rest Enndpoint.
 *
 * @package BuddyBossApp\Migration
 */

namespace BuddyBossApp\Migration;

use BuddyBossApp\Migration\DeepLinking\Api\V1\RestAPI as DeepLinkingRestAPIv1;
use BuddyBossApp\Migration\DeepLinking\Api\V2\RestAPI as DeepLinkingRestAPIv2;

/**
 * Class DeepLinking
 *
 * @package BuddyBossApp\Migration
 */
class DeepLinking {

	/**
	 * Class instance.
	 *
	 * @var object $instance .
	 */
	private static $instance;

	/**
	 * API Namespace.
	 *
	 * @var string
	 */
	protected $namespace = 'appboss/core/v1';

	/**
	 * DeepLinking constructor.
	 */
	public function __construct() {
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return DeepLinking
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Load deep linking types
	 */
	public function load() {
		DeepLinkingRestAPIv1::instance();
		DeepLinkingRestAPIv2::instance();
	}
}
