<?php

namespace BuddyBossApp\Migration\DeepLinking\Api\V2;

class RestAPI {

	private static $instance;
	private static $version = 'v2';
	private static $namespace;

	public function __construct() {
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return DeepLinking
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {

			self::$namespace = 'appboss/core/' . self::$version;

			/**
			 * @var $class DeepLinking
			 */
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->_load();
		}

		return self::$instance;
	}

	/**
	 * Load deep linking types
	 */
	public function _load() {

		add_action( 'rest_api_init', array( $this, 'register_routes' ), 99 );

	}

	/**
	 * Register all required route for Deep Linking..
	 */
	public function register_routes() {

		register_rest_route(
			self::$namespace,
			'/url-details',
			array(
				array(
					'methods'             => \WP_REST_Server::EDITABLE,
					'callback'            => array( $this, 'url_details' ),
					'permission_callback' => '__return_true',
					'args'                => array(
						'url' => array(
							'required'    => true,
							'type'        => 'string',
							'description' => __( 'URL', 'buddyboss-app' ),
						),
					),
				),
			)
		);

		register_rest_route(
			self::$namespace,
			'/bulk-url-details',
			array(
				array(
					'methods'             => \WP_REST_Server::EDITABLE,
					'callback'            => array( $this, 'bulk_url_details' ),
					'permission_callback' => '__return_true',
					'args'                => array(
						'urls' => array(
							'required'    => true,
							'type'        => 'array',
							'items'       => array(
								'type' => 'string',
							),
							'description' => __( 'URLs', 'buddyboss-app' ),
						),
					),
				),
			)
		);

	}

	/**
     * @apiPrivate
	 * @api            {PATCH} /wp-json/appboss/core/v2/url-details Url details
	 * @apiName        UpdateDeepLinkingUrlDetails
	 * @apiGroup       DeepLinking
	 * @apiVersion     1.0.0
	 * @apiPermission  Public
	 * @apiDescription Update deep-linking URL Details.
	 * @apiParam       url URL Details. (Must be valid url)
	 */

	public function url_details( $request ) {
		global $wp_rest_server;

		$request_curl = new \WP_REST_Request( 'POST', '/buddyboss-app/core/v2/url-details' );
		$request_curl->set_body_params( $request->get_params() );
		$response = $this->dispatch( $request_curl );

		return $wp_rest_server->response_to_data( rest_ensure_response( $response ), isset( $request['_embed'] ) ? 1 : 0 );
	}

	/**
	 * @param $request
	 *
	 * @return array
     * @apiPrivate
	 * @api            {POST} /wp-json/appboss/core/v2/bulk-url-details  bulk Url(deep-linking) details
	 * @apiName        UpdateDeepLinkingUrlDetails
	 * @apiGroup       DeepLinking
	 * @apiVersion     1.0.0
	 * @apiPermission  Public
	 * @apiDescription Get deep-linking URL Details.
	 * @apiParam       url URL Details. (Must be valid url)
	 * @apiError {Object}  Response object
	 */
	public function bulk_url_details( $request ) {
		global $wp_rest_server;

		$request_curl = new \WP_REST_Request( 'POST', '/buddyboss-app/core/v2/bulk-url-details' );
		$request_curl->set_body_params( $request->get_params() );
		$response = $this->dispatch( $request_curl );

		return $wp_rest_server->response_to_data( rest_ensure_response( $response ), isset( $request['_embed'] ) ? 1 : 0 );
	}

	/**
	 * Dispatch the request item.
	 *
	 * @param \WP_REST_Request $request Rest request.
	 *
	 * @return mixed
	 */
	protected function dispatch( $request ) {

		$query_params = $request->get_params();

		if ( isset( $request->get_query_params()['_embed'] ) ) {
			$query_params['_embed'] = $request->get_query_params()['_embed'];
		}

		$request->set_query_params( $query_params );

		$server   = rest_get_server();
		$response = $server->dispatch( $request );

		return $response;
	}

}
