<?php
/**
 * Note: This is temp migration file. on the final merge of this repo on master this should be moved into dadicated migration plugin.
 */

namespace BuddyBossApp\Migration;

use BuddyBossApp\Helpers\BBAPP_File;
use BuddyBossApp\Helpers\File;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Build' ) ) {
	class Build {

		private static $instance;

		/**
		 * Get the instance of the class.
		 *
		 * @return Typography
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) ) {
				$class          = __CLASS__;
				self::$instance = new $class;
				self::$instance->_load();
			}

			return self::$instance;
		}

		/**
		 * Migrate constructor.
		 */
		public function __construct() {
		}

		/**
		 * Migrate load method.
		 */
		public function _load() {
			// this hook should load first.
			$this->rename_upload_folder();
			add_action( 'plugins_loaded', array( $this, 'migrate_load' ), 1 );
		}

		/**
		 * Migrate the options name.
		 */
		public function migrate_load() {
			$this->migrate_build_settings_data();
		}

		/**
		 * Migrate old typography fonts to new folder location.
		 */
		public function rename_upload_folder() {
			$upload_dir = wp_upload_dir();
			$dir_old    = $upload_dir["basedir"] . "/ab-upload";
			$dir_new    = $upload_dir["basedir"] . "/bbapp/uploads";

			if ( bbapp_get_network_option( "bbapp_migrate_build_path" ) != "1" ) {

				if ( file_exists( $dir_old ) ) {
					BBAPP_File::create_dir($dir_new);
					BBAPP_File::copy_dir( $dir_old, $dir_new );
				}

				bbapp_set_network_option( "bbapp_migrate_build_path", "1" );
			}
		}

		/**
		 * No not modify nature of below code. as they won't be executed on already run sites.
		 * If you want to modify write a new function.
		 */
		public function migrate_build_settings_data() {
			$bbapp_migration = get_option( 'bbapp_migrate_build_settings' );
			if ( "1" !== $bbapp_migration ) {
				$build_settings = \BuddyBossApp\Admin\Build::instance()->get_settings();
				update_option( '_migration_build_settings', $build_settings );
				if ( isset( $build_settings ) ) {
					foreach ( $build_settings as $key => $build_setting ) {
						if ( is_array( $build_setting ) ) {
							foreach ( $build_setting as $setting_key => $setting ) {
								$build_settings[ $key ][ $setting_key ] = str_replace( "/ab-upload/", "/bbapp/uploads/", $setting );
							}
						} else {
							$build_settings[ $key ] = str_replace( "/ab-upload/", "/bbapp/uploads/", $build_setting );
						}
					}
					\BuddyBossApp\Admin\Build::instance()->save_settings( $build_settings );
				}
				update_option( 'bbapp_migrate_build_settings', "1" );
			}
		}
	}
}