<?php

namespace BuddyBossApp\Migration;

if ( ! function_exists( 'add_action' ) ) {
	die( "Sorry, you can't access this directly - Security established" );
}

use BuddyBossApp\Migration\Auth\Rest;
use BuddyBossApp\Migration\Auth\Restv2;

class Auth {

	private static $instance;

	public function __construct() {
	}

	/**
	 * Get class instance
	 *
	 * @return Auth
	 */
	public static function instance() {

		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
			self::$instance->initiate();
		}

		return self::$instance;
	}

	/**
	 * Loads when the class is loaded first time.
	 */
	public function initiate() {
		// Register all hooks.
		$this->hooks();
	}

	/**
	 * Register all hooks
	 *
	 * @return void
	 * @since 1.0,0
	 */
	public function hooks() {
		add_action( 'plugins_loaded', array( $this, "loadRest" ) );
	}

	/**
	 * Load the Rest API.
	 */
	public function loadRest() {
		// Load REST API Functionality
		Rest::instance();
		Restv2::instance();
	}
}
