<?php

namespace BuddyBossApp\Migration;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use BuddyBossApp\ClientCommon;
use BuddyBossApp\ManageApp;

class AppMenu {

	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return AppMenu
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->_load();
		}

		return self::$instance;
	}

	/**
	 * AppMenu constructor.
	 */
	public function __construct() {
	}

	/**
	 *
	 */
	public function _load() {
		//add_filter( "bbapp_app_menu_filter", array( $this, 'filterByDependency' ), 10, 1 );
		add_filter( "bbapp_settings_rest_response", array( $this, 'setting_response' ), 10, 2 );
	}

	public function setting_response( $response, $request ) {

		$appSettings = ManageApp::instance()->get_app_settings();

		if ( ! empty( $appSettings['menu'] ) ) {

			// strip more menu as on old api more was nt around.
			foreach ( $appSettings['menu']['tabbar'] as $k => $v ) {
				if ( $v["object"] == "more"
				) {
					$value = array(
						"uri"                => $v["icon"]["uri"],
						"monochrome_setting" => $v["icon"]["monochrome_setting"],
						"icon_style"         => $v["icon"]["icon_style"]
					);
				}
			}

		}

		if ( ! isset( $value ) ) {
			$value = array(
				"uri"                => "appboss/menu",
				"monochrome_setting" => '',
				"icon_style"         => 'outlined'
			);
		}

		$value['monochrome_setting'] = str_replace( '\\', '', $value['monochrome_setting'] );
		$value['monochrome_setting'] = json_decode( $value['monochrome_setting'], ARRAY_A );

		$icons_path = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_app_icon_url();
		$default    = $icons_path . 'feather-menu.png';

		$tabbar_more_menu_icon["uri"]        = $this->get_icon_uri( $value["uri"], $default, $value['icon_style'] );
		$tabbar_more_menu_icon["tint_color"] = $response["app_menu"]["ios"]["tabbar_more_menu_icon"]["tint_color"] = isset( $value["monochrome_setting"]['icon_monochrome_color'] ) ? $value["monochrome_setting"]['icon_monochrome_color'] : '';

		$response["app_menu"]["android"]["tabbar_more_menu_icon"] = $response["app_menu"]["ios"]["tabbar_more_menu_icon"] = $tabbar_more_menu_icon;

		return $response;

	}

	/**
	 * Return the Icon URI.
	 *
	 * @param      $icon
	 * @param bool $default
	 * @param      $icon_style
	 *
	 * @return bool|string
	 */
	public function get_icon_uri( $icon, $default = false, $icon_style = 'filled' ) {

		$icons_path = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_app_icon_url();
		$icons_dir  = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_app_icon_dir();

		if ( empty( $icon ) ) {
			return $default;
		}

		if ( strpos( $icon, 'custom/' ) !== false ) {

			// if it's custom uploaded icon.
			$icon       = str_replace( 'custom/', '/', $icon ); // remove the identifier.
			$icons_path = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_custom_icon_url();
			$icons_dir  = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_custom_icon_dir();

		}

		if ( file_exists( $icons_dir . $icon . '-' . $icon_style . '.png' ) ) {
			return $icons_path . $icon . '-' . $icon_style . '.png';
		} elseif ( file_exists( $icons_dir . $icon ) ) {
			return $icons_path . $icon;
		} else {
			return $default;
		}

	}

	/**
	 * Returns the app menu data.
	 *
	 * @param $appId
	 *
	 * @return array|bool
	 */
	public function get_menu() {

		$appMenu = array();

		if ( empty( $appInfo ) ) {
			return false;
		}

		$appSettings = ManageApp::instance()->get_app_settings();

		if ( ! empty( $appSettings['menu'] ) ) {
			// strip more menu as on old api more was nt around.
			foreach ( $appSettings['menu']['tabbar'] as $k => $v ) {
				if ( $v["object"] == "more"
				) {
					unset( $appSettings['menu']['tabbar'][ $k ] );
				}
			}
			$appMenu = array_merge( $appSettings['menu']['tabbar'], $appSettings['menu']['more'] );
		}

		if ( empty( $appMenu ) ) {
			$appMenu = $this->get_default_appmenu();
		}

		//$appMenu = apply_filters( 'bbapp_app_menu_filter', $appMenu );

		return $appMenu;
	}

	/**
	 * BuddyBoss App menu id adding.
	 *
	 * @param $appId
	 * @param $app_settings
	 *
	 * @return mixed
	 */
	public function add_menus_id_in_menu_setting( $app_settings ) {

		foreach ( $app_settings['menu_settings'] as $key => $appMenu ) {
			if ( ! array_key_exists( 'id', $appMenu ) ) {
				$appMenu['id']        = uniqid();
				$app_settings['menu_settings'][ $key ] = $appMenu;
			}
		}
		\BuddyBossApp\ManageApp::instance()->update_app_settings( $app_settings );

		return $app_settings;
	}

	/**
	 * Returns the default menu data of specific app.
	 *
	 * @return mixed
	 */
	public function get_default_appmenu() {
		$appMenu = array();

		$stylingOptionColors = bbapp_get_default_tab_color();
		$default_color       = $stylingOptionColors['default_color'];

		$appHomePage = bbapp_get_page_by_title( 'Home', OBJECT, 'app_page' );
		if ( $appHomePage ) {
			$appMenu[] = array(
				"name"     => "home",
				'id'       => uniqid(),
				"label"    => __( "Home", 'buddyboss-app' ),
				"type"     => "app_page",
				'data'     => array(
					'id'     => $appHomePage->ID,
					'link'   => get_permalink( $appHomePage->ID ),
					'parent' => 0,
				),
				"settings" => array(),
				"on"       => true,
				"icon"     => array(
					'uri'        => 'appboss/home',
					'tint_color' => $default_color,
				),
			);
		}

		$appMenu = apply_filters( 'bbapp_default_app_menus', $appMenu );

		// Make Sure Widget Cast is Array not Object to avoid [0:{},1:{}] we expect [{},{}];
		$appMenu = array_values( $appMenu );

		return $appMenu;
	}

	/**
	 * Rest Endpoint Function for Returning App Menu
	 *
	 * @param $request
	 *
	 * @return mixed
	 */
	public function rest_response( $request ) {
		$bbappId = isset( $request['app_id'] ) && ! empty( $request['app_id'] ) ? $request['app_id'] : '';

		$appId = $app['app_id'];

		$appMenu = $this->get_menu();

		if ( ! $appMenu ) {
			$app_menu = array(
				'tabbar' => array(),
				'more'   => array(),
			);
			return rest_ensure_response( $app_menu );
		}

		$common = ClientCommon::instance();

		foreach ( $appMenu as $k => $menu ) {

			if ( 'section' == $menu['type'] ) {

				if ( ! is_array( $appMenu[ $k ]['section'] ) ) // make sure section is array format.
				{
					$appMenu[ $k ]['section'] = array();
				}

				if ( ! empty( $menu['section'] ) && is_array( $menu['section'] ) ) {

					foreach ( $menu['section'] as $j => $section_menu ) {
						$appMenu[ $k ]['section'][ $j ] = $this->get_user_app_menu_filter_menu_data( $appMenu[ $k ]['section'][ $j ], $j, $request, true );
						$section_menu_object_name       = ! empty( $section_menu['object'] ) ? $section_menu['object'] : $section_menu['name'];
						switch ( $section_menu_object_name ) {

							case "activity" :

								if ( ! $common->is_active_logic( array( "buddypress", "buddypress_activity" ) ) ) {
									unset( $appMenu[ $k ]['section'][ $j ] );
								}

								break;
							case "members":
								if ( ! $common->is_active_logic( array( "buddypress", "buddypress_members" ) ) ) {
									unset( $appMenu[ $k ]['section'][ $j ] );
								}

								break;
							case "profile":
								if ( ! $common->is_active_logic( array( "buddypress", "buddypress_profile" ) ) ) {
									unset( $appMenu[ $k ]['section'][ $j ] );
								}

								break;
							case  "messages":
								if ( ! $common->is_active_logic( array( "buddypress", "buddypress_messages" ) ) ) {
									unset( $appMenu[ $k ]['section'][ $j ] );
								}

								break;
							case  "documents":
								if ( ! $common->is_active_logic( array( "buddypress", "buddypress_documents" ) ) ) {
									unset( $appMenu[ $k ]['section'][ $j ] );
								}

								break;
							case  "photos":
								if ( ! $common->is_active_logic( array( "buddypress", "buddypress_photos" ) ) ) {
									unset( $appMenu[ $k ]['section'][ $j ] );
								}

								break;

							case "topics":
							case "forums":

								if ( ! $common->is_active_logic( array( "bbapp_bbpress_api", "bbpress" ) ) ) {
									unset( $appMenu[ $k ]['section'][ $j ] );
								}

								break;

							case "groups":

								if ( ! $common->is_active_logic( array( "buddypress", "buddypress_groups" ) ) ) {
									unset( $appMenu[ $k ]['section'][ $j ] );
								}

								break;

							case "courses":
							case "courses_all":
								if ( ! $common->is_active_logic( array( "bbapp_learner_api" ) ) && ! $common->is_active_logic( array( "bbapp_tutor_lms_api" ) ) ) {
									unset( $appMenu[ $k ]['section'][ $j ] );
								}
								break;
							case "course_certificates":
							case "courses_category":
								if ( ! $common->is_active_logic( array( "bbapp_learner_api" ) ) ) {
									unset( $appMenu[ $k ]['section'][ $j ] );
								}
								break;
						}
					}

					// NOTE : Need to do this else =>  2: { }
					$appMenu[ $k ]['section'] = array_values( $appMenu[ $k ]['section'] );

				}

			} else {
				$menu_can_add     = true;
				$menu_object_name = ! empty( $appMenu[ $k ]['object'] ) ? $appMenu[ $k ]['object'] : $appMenu[ $k ]['name'];
				switch ( $menu_object_name ) {

					case "activity" :

						if ( ! $common->is_active_logic( array( "buddypress", "buddypress_activity" ) ) ) {
							unset( $appMenu[ $k ] );
							$menu_can_add = false;
						}

						break;
					case "members":
						if ( ! $common->is_active_logic( array( "buddypress", "buddypress_members" ) ) ) {
							unset( $appMenu[ $k ] );
							$menu_can_add = false;
						}

						break;
					case "profile":
						if ( ! $common->is_active_logic( array( "buddypress", "buddypress_profile" ) ) ) {
							unset( $appMenu[ $k ] );
							$menu_can_add = false;
						}

						break;
					case  "messages":
						if ( ! $common->is_active_logic( array( "buddypress", "buddypress_messages" ) ) ) {
							unset( $appMenu[ $k ] );
							$menu_can_add = false;
						}

						break;
					case  "documents":
						if ( ! $common->is_active_logic( array( "buddypress", "buddypress_documents" ) ) ) {
							unset( $appMenu[ $k ] );
							$menu_can_add = false;
						}

						break;
					case  "photos":
						if ( ! $common->is_active_logic( array( "buddypress", "buddypress_photos" ) ) ) {
							unset( $appMenu[ $k ] );
							$menu_can_add = false;
						}

						break;
					case "topics":
					case "forums":

						if ( ! $common->is_active_logic( array( "bbapp_bbpress_api", "bbpress" ) ) ) {
							unset( $appMenu[ $k ] );
							$menu_can_add = false;
						}

						break;

					case "groups":

						if ( ! $common->is_active_logic( array( "buddypress", "buddypress_groups" ) ) ) {
							unset( $appMenu[ $k ] );
							$menu_can_add = false;
						}

						break;

					case "courses":
					case "courses_all":
						if ( ! $common->is_active_logic( array( "bbapp_learner_api" ) ) && ! $common->is_active_logic( array( "bbapp_tutor_lms_api" ) ) ) {
							unset( $appMenu[ $k ] );
							$menu_can_add = false;
						}
						break;
					case "course_certificates":
					case "courses_category":
						if ( ! $common->is_active_logic( array( "bbapp_learner_api" ) ) ) {
							unset( $appMenu[ $k ] );
							$menu_can_add = false;
						}
						break;
				}
				if ( true === $menu_can_add ) {
					$appMenu[ $k ] = $this->get_user_app_menu_filter_menu_data( $appMenu[ $k ], $request, $k );
				}
			}
		}


		return rest_ensure_response( array_values( $appMenu ) );
	}

	/**
	 * Filter menu data.
	 *
	 * @param       $menu
	 * @param       $request
	 * @param       $index
	 * @param int $appId
	 * @param false $is_section
	 *
	 * @return mixed
	 */
	public function get_user_app_menu_filter_menu_data( $menu, $request, $index, $is_section = false ) {
		// convert object to name
		$menu["name"] = ! empty( $menu["object"] ) ? $menu["object"] : $menu["name"];
		unset( $menu["object"] );
		// new method extend class.
		$className = "\BuddyBossApp\Menus\\" . bbapp_camelize( $menu['name'] );

		if ( class_exists( $className ) ) {
			$menu = $className::get_results( $menu, $request );
		}

		// old method extends class.
		if ( class_exists( 'bbapp_' . strtolower( $menu["name"] ) . '_menu' ) ) {
			$class_name = 'bbapp_' . strtolower( $menu["name"] ) . '_menu';
			$menu       = $class_name::get_results( $menu, $request );
		}

		$appSettings                   = \BuddyBossApp\ManageApp::instance()->get_app_settings();
		$menu['data']['open_external'] = ( isset( $menu['data']['open_external'] ) && 'yes' == $menu['data']['open_external'] ) ? true : false;

		// @deprecated. Below option is configure at global level but passed with each menu item
		$menu['data']['show_search'] = true; // always show. // App by default shows search on all screens now.


		$iconDefaults = array(
			"uri" => 'appboss/file',
		);

		/**
		 * Transform URL of Icon & default data.
		 */

		if ( isset( $menu['name'] ) && ! isset( $menu['icon'] ) ) {
			$iconDefaults = bbapp_get_menu_icon( $menu['name'], $menu['type'] );
		}

		if ( ! isset( $menu["icon"] ) ) {
			$menu['icon'] = array();
		}

		$menu["icon"] = array_merge( $iconDefaults, $menu["icon"] );

		// Ios Monochrome Color.
		$ios_monochrome_setting = isset( $menu["icon"]['monochrome_setting'] ) ? $menu["icon"]['monochrome_setting'] : "";
		$ios_monochrome_setting = str_replace( '\\', '', $ios_monochrome_setting );
		$ios_monochrome_data    = json_decode( $ios_monochrome_setting, ARRAY_A );
		$ios_monochrome_color   = isset( $ios_monochrome_data['icon_monochrome_color'] ) ? $ios_monochrome_data['icon_monochrome_color'] : '';

		// Android Monochrome Color
		$android_monochrome_setting = isset( $menu["icon"]['monochrome_setting'] ) ? $menu["icon"]['monochrome_setting'] : "";
		$android_monochrome_setting = str_replace( '\\', '', $android_monochrome_setting );
		$android_monochrome_data    = json_decode( $android_monochrome_setting, ARRAY_A );
		$android_monochrome_color   = isset( $android_monochrome_data['icon_monochrome_color'] ) ? $android_monochrome_data['icon_monochrome_color'] : '';

		// Set ios Monochrome Color.
		if ( isset( $menu["icon"]['monochrome_setting'] ) ) {
			unset( $menu["icon"]['monochrome_setting'] );
			$menu["icon"]['tint_color'] = $ios_monochrome_color;
		}

		// get ios icon value.
		if ( isset( $menu["icon"]['uri'] ) ) {
			$menu["icon"]['uri_value'] = $menu["icon"]['uri'];
		}

		foreach ( array( 'uri' => 'icon_style' ) as $icon_key => $icon_style ) {

			/**
			 * Paths & Dirs
			 */
			$icons_path = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_app_icon_url();
			$icons_dir  = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_app_icon_dir();

			if ( strpos( $menu["icon"][ $icon_key ], "custom/" ) !== false ) {
				// if it's custom uploaded icon.
				$menu["icon"][ $icon_key ] = str_replace( "custom/", "/", $menu["icon"][ $icon_key ] ); // remove the identifier.
				$icons_path                = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_custom_icon_url();
				$icons_dir                 = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_custom_icon_dir();

			}
			$menu["icon"][ $icon_style ] = 'outlined';
			if ( true === $is_section && $index > 3 ) {
				$app_settings                = \BuddyBossApp\AppSettings::instance();
				$menu["icon"][ $icon_style ] = $app_settings->get_setting_value( 'app_menu.more_icon_style' );
			}
			if ( ! empty( $menu["icon"][ $icon_key ] ) ) {
				if ( file_exists( $icons_dir . $menu["icon"][ $icon_key ] . '-' . $menu["icon"][ $icon_style ] . '.png' ) ) {
					$menu["icon"][ $icon_key ] = $icons_path . $menu["icon"][ $icon_key ] . '-' . $menu["icon"][ $icon_style ] . '.png';
				} elseif ( file_exists( $icons_dir . $menu["icon"][ $icon_key ] ) ) {
					$menu["icon"][ $icon_key ] = $icons_path . $menu["icon"][ $icon_key ];
				} else {
					$menu["icon"][ $icon_key ] = "";
				}
			}

			// Set the default when it's empty at this point.
			if ( empty( $menu["icon"][ $icon_key ] ) && isset( $menu["icon"][ $icon_style ] ) ) {
				$menu["icon"][ $icon_key ] = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_app_icon_url() . "file-" . $menu["icon"][ $icon_style ] . ".png";
			}

			/**
			 * Transform URL menu types to page.
			 */

			$pages_type = array( "post", "page", "custom" );
			$pages_type = apply_filters( "bbapp_app_menus_pages_type", $pages_type );

			if ( in_array( $menu["type"], $pages_type ) ) {
				$menu["type"] = "page";
				$menu["name"] = $menu["type"] . "_" . $menu["data"]["id"];
			}

		}

		/**
		 * Transform URL menu types to page.
		 */
		$bbappPageTypes = array( "post", "page" );
		$bbappPageTypes = apply_filters( "bbapp_app_page_types", $bbappPageTypes );

		if ( in_array( $menu["type"], $bbappPageTypes ) ) {
			$menu["type"] = "page";
			$menu["name"] = $menu["type"] . "_" . $menu["data"]["id"];
		}


		if ( empty( $menu['data']['id'] ) ) {
			$menu['data']['id'] = $menu["name"];
		}
		// If app page so we should pass the app page url.

		if ( 'app_page' === $menu["name"] ) {
			$menu['data']['link'] = get_permalink( $menu['data']['id'] );
			$menu["name"]         = $menu['data']['id'];
			$menu["type"]         = 'app_page';
		}

		if ( 'page' === $menu["name"] ) {
			$menu["type"] = "page";
			$menu["name"] = $menu["type"] . "_" . $menu["data"]["id"];
		}

		return apply_filters( 'bbapp_menu_filter_menu_data', $menu );


	}

	/**
	 * Todo: used this function in menu.
	 * Filters Menu based on there dependence.
	 *
	 * @param $appMenu
	 *
	 * @return mixed
	 */
	public function filterByDependency( $appMenu ) {
		$common = ClientCommon::instance();

		if ( ! is_array( $appMenu ) ){
			return array();
		}

		foreach ( $appMenu as $k => $v ) {
			if ( isset( $v["name"] ) ) {
				$name = $v["name"];
			} else if(isset( $v["object"] )){
				$name =  $v["object"];
			}
			switch ( $name ) {

				case "activity":
					if ( ! $common->is_active_logic( array( "buddypress", "buddypress_activity" ) ) ) {
						unset( $appMenu[ $k ] );
					}

					break;

				case "members":
					if ( ! $common->is_active_logic( array( "buddypress", "buddypress_members" ) ) ) {
						unset( $appMenu[ $k ] );
					}

					break;

				case "profile":
					if ( ! $common->is_active_logic( array( "buddypress", "buddypress_profile" ) ) ) {
						unset( $appMenu[ $k ] );
					}

					break;

				case  "messages":
					if ( ! $common->is_active_logic( array( "buddypress", "buddypress_messages" ) ) ) {
						unset( $appMenu[ $k ] );
					}
					break;

				case  "documents":
					if ( ! $common->is_active_logic( array( "buddypress", "buddypress_documents" ) ) ) {
						unset( $appMenu[ $k ] );
					}
					break;

				case "topics":
				case "forums":

					if ( ! $common->is_active_logic( array( "bbapp_bbpress_api", "bbpress" ) ) ) {
						unset( $appMenu[ $k ] );
					}

					break;

				case "groups":

					if ( ! $common->is_active_logic( array( "buddypress", "buddypress_groups" ) ) ) {
						unset( $appMenu[ $k ] );
					}
					break;

				case "courses":
				case "courses_all":
					if ( ! $common->is_active_logic( array( "bbapp_learner_api" ) ) && ! $common->is_active_logic( array( "bbapp_tutor_lms_api" ) ) ) {
						unset( $appMenu[ $k ] );
					}
					break;
				case "course_certificates":
				case "courses_category":

					if ( ! $common->is_active_logic( array( "bbapp_learner_api" ) ) ) {
						unset( $appMenu[ $k ] );
					}
					break;

				case "iap_products":

					if ( ! $common->is_active_logic( array( "bbapp_iap" ) ) ) {
						unset( $appMenu[ $k ] );
					}
					break;

				case "section":
					$appMenu[ $k ]['section'] = $this->filterByDependency( $appMenu[ $k ]['section'] );
					break;
			}
		}

		return $appMenu;
	}
}
