<?php

namespace BuddyBossApp\Migration\Admin\Appearance;

// Exit if accessed directly

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'AppMenu' ) ):

	class AppMenu {

		private $_messages = array();

		private $is_current_page = false;

		private static $instance;

		/**
		 * Get the instance of the class.
		 *
		 * @return AppMenu
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) ) {
				$class          = __CLASS__;
				self::$instance = new $class;
				self::$instance->_load();
			}

			return self::$instance;
		}

		/**
		 * AppMenu constructor.
		 */
		public function __construct() {
		}

		/**
		 *
		 */
		public function _load() {
			add_action( 'wp_ajax_add-appmenu-item', array( $this, 'wpAjaxAddAppmenuItem' ) );
			add_action( "admin_init", array( $this, "adminInit" ) );
		}

		/**
		 * Functions tells & sets thats if current page is one where it's will render.
		 *
		 * @param bool $set
		 *
		 * @return bool
		 */
		public function will_render( $set = false ) {

			if ( $set ) {
				$this->is_current_page = true;
			}

			return $this->is_current_page;
		}

		/**
		 *
		 */
		public function adminInit() {

			if ( ( ! is_admin() && ! is_network_admin() ) || ! current_user_can( 'manage_options' ) ) {
				return;
			}
			//$this->process_submit();
			add_filter( 'admin_body_class', array( $this, 'custom_body_class' ), 99 );
		}

		/**
		 * Renders the app menu backend page.
		 */
		public function render() {
			include bbapp()->plugin_dir . '/include/Migration/views/branding/tabbar.php';
		}

		/**
		 * Output the error or update messages to render.
		 */
		public function show_messages() {

			if ( ! empty( $this->_messages ) ) {
				foreach ( $this->_messages as $message ) {
					echo "<div id='message' class='{$message['type']}'><p>{$message['message']}</p></div>";
				}
			}

		}

		/**
		 * Renders all menu items.
		 */
		public function render_menu_metabox() {

			// Core App
			add_meta_box( "add-post-type-core-app-menu", __( 'Core App', 'buddyboss-app' ), array(
				$this,
				'render_core_app_menu_markup',
			), 'nav-menus', 'side', 'core', 'core_app_menu' );

			// Post Types -> App Pages and WordPress Pages
			$post_types = get_post_types( array( 'show_in_nav_menus' => true ), 'object' );

			if ( ! $post_types ) {
				return;
			}

			$allowed_post_type = array( "page" );
			$allowed_post_type = apply_filters( "bbapp_app_menus_allowed_post_types", $allowed_post_type );

			foreach ( $post_types as $post_type ) {

				if ( ! in_array( $post_type->name, $allowed_post_type ) ) {
					continue;
				}

				/**
				 * Filter whether a menu items meta box will be added for the current
				 * object type.
				 **/
				//$post_type = apply_filters( 'nav_menu_meta_box_object', $post_type );

				if ( $post_type ) {
					$id = $post_type->name;
					// Give App Pages a higher priority.
					$priority      = ( 'app_page' == $post_type->name ? 'core' : 'default' );
					$postTypeLabel = $post_type->labels->name;
					switch ( $postTypeLabel ) {
						case 'Pages';
							$postTypeLabel = 'WordPress Pages';
							break;
					}
					add_meta_box( "add-post-type-{$id}", $postTypeLabel, 'wp_nav_menu_item_post_type_meta_box', 'nav-menus', 'side', $priority, $post_type );
				}

			}
			// Custom Links
			add_meta_box( 'add-post-type-custom-links-app-menu', __( 'Custom Links', 'buddyboss-app' ), 'wp_nav_menu_item_link_meta_box', 'nav-menus', 'side', 'default', 'core_app_custom_link' );

			// Sections
			add_meta_box( "add-post-type-core-app-section", __( 'Sections', 'buddyboss-app' ), array(
				$this,
				'render_core_app_menu_section_markup',
			), 'nav-menus', 'side', 'default', 'core_app_section' );

		}

		/**
		 * Renders Sections Menu.
		 */
		public function render_core_app_menu_section_markup() {
			include bbapp()->plugin_dir . "/views/appearance/appmenu-section-markup.php";
		}

		/**
		 * Renders BuddyBossApp Core Menu Types.
		 */
		public function render_core_app_menu_markup() {
			$app_menu = $this->get_core_appmenu();
			include bbapp()->plugin_dir . "/Migration/views/appearance/appmenu-core-markup.php"; //this file removed.
		}

		/**
		 * Saves app menu settings.
		 *
		 * @return bool|void
		 */
		public function process_submit() {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( - 1 );
			}

			if ( ! isset( $_POST['update-nav-appmenu-nonce-old'] ) ) {
				return;
			}

			if ( ! check_admin_referer( 'update-nav_appmenu-old', 'update-nav-appmenu-nonce-old' ) ) {
				$this->_messages[] = array(
					'type'    => 'error',
					'message' => __( 'Something unexpected happened. Please try again later.', 'buddyboss-app' ),
				);
			}

			$menu_items = @$_POST['appmenu-item'];

			if ( ! empty( $menu_items ) ) {
				foreach ( $menu_items as $m => $menu_item ) {
					if ( isset( $menu_item['section'] ) ) {
						$menu_item_section = array();
						foreach ( $menu_items as $k => $m_item ) {
							if ( $m_item['data']['id'] != $menu_item['data']['id'] && $m_item['data']['parent'] == $menu_item['data']['id'] ) {
								$menu_item_section[] = $m_item;
								unset( $menu_items[ $k ] );
							}
						}
						$menu_items[ $m ]['section'] = ! empty( $menu_item_section ) ? array_values( $menu_item_section ) : '1';
					}
				}
			} else {
				$menu_items = array();
			}

			$menu_items                    = array_values( $menu_items );
			$app_settings                  = \BuddyBossApp\ManageApp::instance()->get_app_settings();
			$app_settings['menu_settings'] = $menu_items;

			// Save Menu Settings.
			$menu_settings = isset( $_POST['appmenu_settings'] ) ? $_POST['appmenu_settings'] : array();

			if ( ! is_array( $menu_settings ) ) {
				$menu_settings = array();
			}

			// Settings key allowed to be saved.
			$whitelist_settings_key = array(
				"appmenu_labels"            => "bool",
				"tabbar_more_menu_icon"     => "array",
				"tab_bar_icon_style"            => "string",
				"more_icon_style"               => "string",
			);

			foreach ( $whitelist_settings_key as $setting_key => $type ) {
				$setting_value = ( isset( $menu_settings[ $setting_key ] ) ) ? $menu_settings[ $setting_key ] : "";

				// correct the type of data.
				if ( $type == "bool" ) {
					if ( $setting_value == "1" ) {
						$setting_value = true;
					} else {
						$setting_value = false;
					}
				}

				if ( $type == "array" ) {
					if ( ! is_array( $setting_value ) ) {
						$setting_value = array();
					}
				}
				$app_settings["settings"]["app_menu.{$setting_key}"] = $setting_value;
			}

			\BuddyBossApp\ManageApp::instance()->update_app_settings( $app_settings );

			$this->_messages[] = array(
				'type'    => 'updated',
				'message' => __( '<strong>Tab Bar</strong> has been updated.', 'buddyboss-app' ),
			);

			return true;
		}

		/**
		 * Set a custom css on body of the page where current render will initiate.
		 *
		 * @param $classes
		 *
		 * @return string
		 */
		public function custom_body_class( $classes ) {

			if ( $this->will_render() ) {
				if ( strpos( $classes, 'nav-appmenu' ) == false ) {
					$classes .= ' nav-appmenu buddyboss-app-menu';
				}
			}

			return $classes;
		}

		/**
		 * Called when new app menu is added.
		 */
		public function wpAjaxAddAppmenuItem() {
			check_ajax_referer( 'add-appmenu_item', 'menu-settings-column-nonce' );
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( - 1 );
			}

			$menu_items = array();
			foreach ( (array) $_POST['menu-item'] as $menu_item_data ) {

				if (
					( ! empty( $menu_item_data['menu-item-type'] ) && $menu_item_data['menu-item-type'] == "custom" ) || // Custom Menu Type

					( ! empty( $menu_item_data['menu-item-type'] ) && ! empty( $menu_item_data['menu-item-object-id'] ) ) // Or other menu type

				) {

					switch ( $menu_item_data['menu-item-type'] ) {
						case 'post_type':
							$_object = get_post( $menu_item_data['menu-item-object-id'] );
							break;
						case 'core_app_menu':
						case 'custom':
						case 'core_app_menu_section':
							$_object = $menu_item_data;
							break;
					}

					if ( ! empty( $_object ) ) {
						$object_item          = array();
						$object_item['name']  = ! empty( $_object->post_name ) ? $_object->post_name : $_object['menu-item-object-id'];
						$object_item['label'] = $menu_item_data['menu-item-title'];
						$object_item['type']  = ( isset( $menu_item_data['menu-item-object'] ) ) ? $menu_item_data['menu-item-object'] : $menu_item_data['menu-item-type'];
						$object_item['data']  = array();

						if ( 'section' == $menu_item_data['menu-item-object'] ) {
							$id = uniqid();
						}

						if ( $object_item['type'] == "custom" ) {
							$object_item['name'] = md5( $menu_item_data["menu-item-url"] );
							$object_item['url']  = $menu_item_data["menu-item-url"];
						}

						$object_item['data']['id']       = ! empty( $id ) ? $id : $menu_item_data['menu-item-object-id'];
						$object_item['data']['parent']   = ! empty( $id ) ? $id : $menu_item_data['menu-item-parent-id'];
						$object_item['data']['classes']  = $menu_item_data['menu-item-classes'];
						$object_item['data']['link']     = ! empty( $menu_item_data['menu-item-url'] ) ? $menu_item_data['menu-item-url'] : '#';
						$object_item['data']['position'] = 1;
						$object_item['on']               = true;
						$object_item['section']          = 'section' == $menu_item_data['menu-item-object'] ? '1' : '0';

						if ( isset( $object_item['name'] ) && ! isset( $object_item['icon'] ) ) {
							$object_item['icon'] = bbapp_get_menu_icon( $object_item['name'], $object_item['type'] );
						}
						if ( 'custom' === $object_item['type'] ) {
							$object_item['icon'] = array(
								'uri'     => 'appboss/web-link',
							);
						}

						$menu_items[] = $object_item;
					}
				}
			}

			$allowed_post_type = array( "post", "page" );
			$allowed_post_type = apply_filters( "bbapp_app_menus_allowed_post_types", $allowed_post_type );

			ob_start();
			foreach ( $menu_items as $menu_item ) {

				switch ( $menu_item['type'] ) {
					case 'core':
						$this->render_appmenu_core( $menu_item, uniqid() );
						break;
					case 'section':
						$this->render_appmenu_page( $menu_item, $menu_item['data']['id'] );
						break;
					case 'custom':
						$this->render_appmenu_page( $menu_item, uniqid() );
						break;
				}

				if ( in_array( $menu_item['type'], $allowed_post_type ) ) {
					$this->render_appmenu_page( $menu_item, uniqid() );
				}

			}
			echo ob_get_clean();

			wp_die();
		}

		/**
		 * @param        $menu_item
		 * @param string $key
		 * @param int    $depth
		 */
		public function render_appmenu_page( $menu_item, $key = '', $depth = 0 ) {

			$menu_name  = $menu_item['name'];
			$menu_label = $menu_item['label'];
			$menu_type  = $menu_item['type'];

			if ( $menu_type == 'custom' ) {
				$menu_type_label = __( 'custom link', 'buddyboss-app' );
			} elseif ( $menu_type == 'core' ) {
				$menu_type_label = __( 'core app', 'buddyboss-app' );
			} elseif ( $menu_type == 'app_page' ) {
				$menu_type_label = __( 'app page', 'buddyboss-app' );
			} else {
				$menu_type_label = $menu_type;
			}

			$menu_id        = ! empty( $key ) ? $key : 0;
			$menu_data_id   = ! empty( $menu_item['data']['id'] ) ? $menu_item['data']['id'] : $key;
			$menu_parent_id = ! empty( $menu_item['data']['parent'] ) ? $menu_item['data']['parent'] : $key;
			$menu_url       = ! empty( $menu_item['data']['link'] ) ? $menu_item['data']['link'] : '';
			$menu_classes   = ! empty( $menu_item['data']['classes'] ) ? $menu_item['data']['classes'] : '';
			if ( ! empty( $menu_item['section'] ) ) {
				if ( is_array( $menu_item['section'] ) ) {
					$menu_section = 1;
				} else if ( '1' == $menu_item['section'] ) {
					$menu_section = 1;
				} else {
					$menu_section = 0;
				}
			} else {
				$menu_section = 0;
			}

			$ios_monochrome_setting = ! empty( $menu_item['icon']['monochrome_setting'] ) ? $menu_item['icon']['monochrome_setting'] : '';
			$menu_ios_icon_uri      = ! empty( $menu_item['icon']['uri'] ) ? $menu_item['icon']['uri'] : '';
			$menu_open_external     = ! empty( $menu_item['data']['open_external'] ) ? $menu_item['data']['open_external'] : '';

			// Icon style
			$ios_icon_style = ! empty( $menu_item['icon']['icon_style'] ) ? $menu_item['icon']['icon_style'] : 'filled';

			// Icon style id
			$ios_icon_style_id = ! empty( $menu_item['icon']['icon_style_id'] ) ? $menu_item['icon']['icon_style_id'] : '#tab_bar_icon_style';


			$branding_options = \BuddyBossApp\Branding::instance()->get_options();
			$branding_values  = isset( $branding_options["styles"] ) ? $branding_options["styles"] : array();


			if ( empty( $branding_values ) ) {
				$ios_default_color = '#908DA1';
			} else {
				$ios_default_color = $branding_options["styles"]['styles.colors.bottomTabsColor'];
			}

			/**
			 * Check unlinked menu items for CPT.
			 */
			$linked = true;

			$cpt_menu_type = array(
				'page',
				'post',
				'app_page',
			);

			$is_readonly = false;
			if ( in_array( $menu_type, $cpt_menu_type ) ) {
				$post = get_post( $menu_data_id );
				if ( empty( $post ) || is_wp_error( $post ) || $post->post_status != "publish" ) {
					$linked = false;
				} else {
					$menu_label  = ! empty( $menu_label ) ? $menu_label : $post->post_title;
					$menu_url    = get_permalink( $post );
					$is_readonly = true;
				}
			}

			include bbapp()->plugin_dir . "/include/Migration/views/appearance/appmenu-markup.php";
		}

		/**
		 * @param        $menu_item
		 * @param string $key
		 * @param int    $depth
		 */
		public function render_appmenu_core( $menu_item, $key = '', $depth = 0 ) {

			$menu_name  = $menu_item['name'];
			$menu_label = $menu_item['label'];
			$menu_type  = $menu_item['type'];

			if ( $menu_type == 'custom' ) {
				$menu_type_label = __( 'custom link', 'buddyboss-app' );
			} elseif ( $menu_type == 'core' ) {
				$menu_type_label = __( 'core app', 'buddyboss-app' );
			} else {
				$menu_type_label = $menu_type;
			}


			$menu_id        = ! empty( $key ) ? $key : $menu_item['data']['id'];
			$menu_data_id   = ! empty( $menu_item['data']['id'] ) ? $menu_item['data']['id'] : $key;
			$menu_parent_id = ! empty( $menu_item['data']['parent'] ) ? $menu_item['data']['parent'] : $key;
			$menu_url       = ! empty( $menu_item['data']['link'] ) ? $menu_item['data']['link'] : '';
			$menu_classes   = ! empty( $menu_item['data']['classes'] ) ? $menu_item['data']['classes'] : '';
			if ( ! empty( $menu_item['section'] ) ) {
				if ( is_array( $menu_item['section'] ) ) {
					$menu_section = 1;
				} else if ( '1' == $menu_item['section'] ) {
					$menu_section = 1;
				} else {
					$menu_section = 0;
				}
			} else {
				$menu_section = 0;
			}

			$menu_ios_icon_uri = ! empty( $menu_item['icon']['uri'] ) ? $menu_item['icon']['uri'] : '';

			$ios_monochrome_setting = ! empty( $menu_item['icon']['monochrome_setting'] ) ? $menu_item['icon']['monochrome_setting'] : '';

			// Icon style
			$ios_icon_style = ! empty( $menu_item['icon']['icon_style'] ) ? $menu_item['icon']['icon_style'] : 'filled';

			// Icon style id
			$ios_icon_style_id = ! empty( $menu_item['icon']['icon_style_id'] ) ? $menu_item['icon']['icon_style_id'] : '#tab_bar_icon_style';

			$branding_options = \BuddyBossApp\Branding::instance()->get_options();
			$branding_values  = isset( $branding_options["styles"] ) ? $branding_options["styles"] : array();

			if ( empty( $branding_values ) ) {
				$ios_default_color = '#908DA1';
			} else {
				$ios_default_color = $branding_options["styles"]['styles.colors.bottomTabsColor'];
			}

			include bbapp()->plugin_dir . "/include/Migration/views/appearance/appmenu-core.php";
		}

		/**
		 * @param bool $app_id
		 *
		 * @return array|bool
		 */
		public function get_core_appmenu() {

			$app_menu = apply_filters( 'bbapp_app_menu', array() );

			$app_menu = apply_filters( 'bbapp_app_menu_filter', $app_menu );

			//Remove duplicate items form menu
			$app_menu = array_intersect_key( $app_menu, array_unique( array_map( 'serialize', $app_menu ) ) );

			return $app_menu;
		}

	}

endif;