<?php
/**
 * Holds section menu functionality.
 *
 * @package BuddyBossApp\Menus\Types
 */

namespace BuddyBossApp\Menus\Types;

use BuddyBossApp\Menu;

/**
 * Class Sections
 *
 * @package BuddyBossApp\Menus\Types
 */
class SectionsMenus extends CoreAbstract {

	/**
	 * SectionsMenus constructor.
	 */
	public function __construct() {
		parent::__construct();
		add_filter( 'bbapp_register_menu_metaboxes', array( $this, 'hide_on_tabbar' ), 99 );
	}

	/**
	 * Setup method.
	 *
	 * @return mixed|void
	 */
	public function setup() {
		$this->register_screen_group(
			'section',
			__( 'Sections', 'buddyboss-app' ),
			array(
				'desc'    => __( 'On the More Screen only, you can visually group menu items together by indenting them within Sections.', 'buddyboss-app' ),
				'is_hide' => true,
			)
		);
	}

	/**
	 * Hide section menu from tabbar.
	 *
	 * @param array $metaboxes Array of metaboxes.
	 *
	 * @return mixed
	 */
	public function hide_on_tabbar( $metaboxes ) {
		$current_menu = isset( $_REQUEST['current_menu'] ) ? bbapp_input_clean( wp_unslash( $_REQUEST['current_menu'] ) ) : Menu::instance()->get_current_menu(); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

		if ( 'more' !== $current_menu ) {
			unset( $metaboxes['section'] );
		}

		return $metaboxes;
	}
}
