<?php
/**
 * Holds post type menu functionality.
 *
 * @package BuddyBossApp\Menus\Types
 */

namespace BuddyBossApp\Menus\Types;

/**
 * Class Post Type Menus
 *
 * @package BuddyBossApp\Menus\Types
 */
class PostTypeMenus extends CoreAbstract {

	/**
	 * Setup method.
	 *
	 * @return mixed|void
	 */
	public function setup() {
		// Custom cpt menu metabox.
		// Load all the nav menu interface functions.
		require_once ABSPATH . 'wp-admin/includes/nav-menu.php';
		$_wp_post_types = get_post_types( array( 'show_in_nav_menus' => true ), 'object' );
		if ( $_wp_post_types ) {
			$allowed_post_type = array( 'page' );
			$allowed_post_type = apply_filters( 'bbapp_app_menus_allowed_post_types', $allowed_post_type );

			foreach ( $_wp_post_types as $_wp_post_type ) {
				if ( ! in_array( $_wp_post_type->name, $allowed_post_type, true ) ) {
					continue;
				}

				/**
				 * Filters whether a menu items meta box will be added for the current
				 * object type.
				 *
				 * If a falsey value is returned instead of an object, the menu items
				 * meta box for the current meta box object will not be added.
				 *
				 * @since 3.0.0
				 *
				 * @param \WP_Post_Type|false $_wp_post_type The current object to add a menu items
				 *                                      meta box for.
				 */
				$_wp_post_type = apply_filters( 'nav_menu_meta_box_object', $_wp_post_type );

				if ( $_wp_post_type ) {
					// Give App Pages a higher priority.
					$post_type_label = ( 'Pages' === $_wp_post_type->labels->name ) ? __( 'WordPress Pages', 'buddyboss-app' ) : $_wp_post_type->labels->name;
					$this->register_screen_group(
						$_wp_post_type->name,
						$post_type_label,
						array(
							'callback' => 'wp_nav_menu_item_post_type_meta_box',
							$_wp_post_type,
						)
					);
				}
			}
		}
	}
}
