<?php
/**
 * Holds custom menu functionality.
 *
 * @package BuddyBossApp\Menus\Types
 */

namespace BuddyBossApp\Menus\Types;

/**
 * Class Custom menus
 *
 * @package BuddyBossApp\Menus\Types
 */
class CustomMenus extends CoreAbstract {

	/**
	 * CustomMenus constructor.
	 */
	public function __construct() {
		parent::__construct();
		add_filter( 'bbapp_register_menu_metaboxes', array( $this, 'hide_on_no_custom_screen' ), 99 );
	}

	/**
	 * Setup method.
	 *
	 * @return mixed|void
	 */
	public function setup() {
		// Custom Menu metbox.
		$this->register_screen_group(
			'custom_screen',
			__( 'Custom Screens', 'buddyboss-app' ),
			array(
				'deeplink_base' => 'screen',
				'desc'          => __( 'Custom Screens are used for displaying content from your custom code.', 'buddyboss-app' ),
			)
		);
		$this->load_menus();
	}

	/**
	 * Load all menus.
	 */
	public function load_menus() {
		$custom_screens = $this->get_custom_app_screen();
		foreach ( $custom_screens as $custom_screen ) {
			$this->register_screen( $custom_screen['object'], $custom_screen['label'], $custom_screen['icon']['uri'], $custom_screen['icon']['monochrome_setting'] );
		}
	}

	/**
	 * Get Custom app menu.
	 *
	 * @return array|bool
	 */
	public function get_custom_app_screen() {

		$custom_app_menus = apply_filters( 'bbapp_custom_app_screen', array() );

		// Remove duplicate items form menu.
		$custom_app_menus = array_intersect_key( $custom_app_menus, array_unique( array_map( 'serialize', $custom_app_menus ) ) );

		return $custom_app_menus;
	}

	/**
	 * Hide custom screen if not custom screen added.
	 *
	 * @param array $metaboxes Array of metaboxes.
	 *
	 * @return mixed
	 */
	public function hide_on_no_custom_screen( $metaboxes ) {
		if ( isset( $metaboxes['custom_screen'] ) ) {
			$all_menus = apply_filters( 'bbapp_get_all_menus', array() );
			if ( ! isset( $all_menus['custom_screen'] ) ) {
				unset( $metaboxes['custom_screen'] );
			}
		}

		return $metaboxes;
	}
}
