<?php
/**
 * Holds core menu functionality.
 *
 * @package BuddyBossApp\Menus\Types
 */

namespace BuddyBossApp\Menus\Types;

use BuddyBossApp\Admin\Settings;
use BuddyBossApp\Bookmark;
use BuddyBossApp\Menus\IapProducts;

/**
 * Class Core Menus
 *
 * @package BuddyBossApp\Menus\Types
 */
class CoreMenus extends CoreAbstract {

	/**
	 * Setup method.
	 *
	 * Setup screen.
	 *
	 * @return mixed|void
	 */
	public function setup() {

		$this->register_screen_group(
			'core',
			__( 'Core App', 'buddyboss-app' ),
			array(
				'deeplink_base' => 'screen',
				'desc'          => __( 'Core App Screens are used for displaying core content that is built into the app.', 'buddyboss-app' ),
			)
		);
		$this->load_menus();
	}

	/**
	 * Load all menus.
	 */
	public function load_menus() {
		$this->register_screen(
			'settings',
			__( 'Settings', 'buddyboss-app' ),
			array(
				'id'   => 'cog',
				'type' => 'buddyboss',
			)
		);
		$this->register_screen(
			'blog',
			__( 'Blog', 'buddyboss-app' ),
			array(
				'id'   => 'article',
				'type' => 'buddyboss',
			)
		);
		if ( bbapp_is_active( 'push_notification' ) && function_exists( 'bp_is_active' ) && bp_is_active( 'notifications' ) ) {
			$this->register_screen(
				'notifications',
				__( 'Notifications', 'buddyboss-app' ),
				array(
					'id'   => 'bell',
					'type' => 'buddyboss',
				),
				array(),
				null,
				null,
				true
			);
		}
		if ( bbapp_is_active( 'iap' ) ) {
			$this->register_screen(
				'iap_products',
				__( 'Products', 'buddyboss-app' ),
				array(
					'id'   => 'membership-card',
					'type' => 'buddyboss',
				),
				'',
				array( IapProducts::instance(), 'menu_metabox' ),
				array( IapProducts::instance(), 'menu_result' )
			);
		}

		// Learndash.
		if ( bbapp_is_learndash_enabled() ) {
			$settings           = Settings::instance()->get_settings( true );
			$course_downloading = $settings['learndash_course_downloading'] ?? 0;

			if ( isset( $course_downloading ) && $course_downloading ) {
				$this->register_screen(
					'my_library',
					__( 'My Library', 'buddyboss-app' ),
					array(
						'id'   => 'books',
						'type' => 'buddyboss',
					)
				);
			}

			$this->register_screen(
				'courses_all',
				__( 'Courses', 'buddyboss-app' ),
				array(
					'id'   => 'course',
					'type' => 'buddyboss',
				)
			);
			$this->register_screen(
				'course_certificates',
				__( 'Course Certificates', 'buddyboss-app' ),
				array(
					'id'   => 'certificate',
					'type' => 'buddyboss',
				)
			);
			$this->register_screen(
				'courses_category',
				__( 'Course Categories', 'buddyboss-app' ),
				array(
					'id'   => 'course',
					'type' => 'buddyboss',
				)
			);
		}

		if ( bbapp_is_tutor_lms_plugins_active() ) {
			$this->register_screen(
				'courses_all',
				__( 'Courses', 'buddyboss-app' ),
				array(
					'id'   => 'course',
					'type' => 'buddyboss',
				)
			);
			$this->register_screen(
				'tutor_dashboard',
				__( 'Dashboard', 'buddyboss-app' ),
				array(
					'id'   => 'user-card',
					'type' => 'buddyboss',
				)
			);
		}

		// BuddyBoss Platform Menus.
		if ( function_exists( 'bp_is_active' ) ) {
			if ( bp_is_active( 'groups' ) ) {
				$this->register_screen(
					'groups',
					__( 'Groups', 'buddyboss-app' ),
					array(
						'id'   => 'users',
						'type' => 'buddyboss',
					)
				);
			}
			if ( bp_is_active( 'members' ) ) {
				$this->register_screen(
					'members',
					__( 'Members', 'buddyboss-app' ),
					array(
						'id'   => 'user-friends',
						'type' => 'buddyboss',
					)
				);
			}
			if ( bp_is_active( 'activity' ) ) {
				$this->register_screen(
					'activity',
					__( 'Activity', 'buddyboss-app' ),
					array(
						'id'   => 'activity',
						'type' => 'buddyboss',
					)
				);
			}
			if ( bp_is_active( 'messages' ) ) {
				$this->register_screen(
					'messages',
					__( 'Messages', 'buddyboss-app' ),
					array(
						'id'   => 'comments',
						'type' => 'buddyboss',
					),
					array(),
					null,
					null,
					true
				);
			}
			if ( bp_is_active( 'xprofile' ) ) {
				$this->register_screen(
					'profile',
					__( 'Profile', 'buddyboss-app' ),
					array(
						'id'   => 'user',
						'type' => 'buddyboss',
					),
					array(),
					null,
					null,
					true
				);
			}

			if ( bp_is_active( 'media' ) ) {
				$this->register_screen(
					'photos',
					__( 'Photos', 'buddyboss-app' ),
					array(
						'id'   => 'image',
						'type' => 'buddyboss',
					)
				);

				if ( ( function_exists( 'bp_is_group_document_support_enabled' ) && bp_is_group_document_support_enabled() ) || ( function_exists( 'bp_is_profile_document_support_enabled' ) && bp_is_profile_document_support_enabled() ) ) {
					$this->register_screen(
						'documents',
						__( 'Documents', 'buddyboss-app' ),
						array(
							'id'   => 'folder-alt',
							'type' => 'buddyboss',
						)
					);
				}
				if ( ( function_exists( 'bp_is_group_video_support_enabled' ) && bp_is_group_video_support_enabled() ) || ( function_exists( 'bp_is_profile_video_support_enabled' ) && bp_is_profile_video_support_enabled() ) ) {
					$this->register_screen(
						'videos',
						__( 'Videos', 'buddyboss-app' ),
						array(
							'id'   => 'video',
							'type' => 'buddyboss',
						)
					);
				}
			}
			if ( function_exists( 'bbpress' ) || ( function_exists( 'bp_is_active' ) && bp_is_active( 'forums' ) ) ) {
				$this->register_screen(
					'forums',
					__( 'Forums', 'buddyboss-app' ),
					array(
						'id'   => 'comments-square',
						'type' => 'buddyboss',
					)
				);
				$this->register_screen(
					'topics',
					__( 'Discussions', 'buddyboss-app' ),
					array(
						'id'   => 'comment-square-dots',
						'type' => 'buddyboss',
					)
				);
			}
		}
		if ( class_exists( 'GamiPress' ) ) {
			$this->register_screen(
				'gamipress_achievements',
				__( 'GamiPress Achievements', 'buddyboss-app' ),
				array(
					'id'   => 'gem',
					'type' => 'buddyboss',
				)
			);
		}

		if ( Bookmark::instance()->bb_is_post_bookmark_enable() ) {
			// Added bookmark menu.
			$this->register_screen(
				'bookmarks',
				__( 'Bookmarks', 'buddyboss-app' ),
				array(
					'id'   => 'bookmark',
					'type' => 'buddyboss',
				)
			);
		}

		/**
		 * Fires after core menus are loaded.
		 *
		 * @param CoreMenus $this Instance of CoreMenus.
		 *
		 * @since 2.2.80
		 */
		do_action( 'bbapp_load_core_menus', $this );
	}
}
