<?php
/**
 * Holds BuddyBoss menus related functionalitu.
 *
 * @package BuddyBossApp\Menus\Types
 */

namespace BuddyBossApp\Menus\Types;

/**
 * Class BB logged in menus
 *
 * @package BuddyBossApp\Menus\Types
 */
class BBMenus extends CoreAbstract {

	/**
	 * BBMenus constructor.
	 */
	public function __construct() {
		parent::__construct();
		add_filter( 'bbapp_register_menu_metaboxes', array( $this, 'hide_on_no_bb_logged_in' ), 99 );
	}

	/**
	 * Setup method.
	 *
	 * @return mixed|void
	 */
	public function setup() {
		// Don't show the Logged-in Member if we are in logged-out tab bar.
		$this->register_screen_group( 'bb_logged_in', __( 'Logged-in Member', 'buddyboss-app' ), array( 'deeplink_base' => 'profile' ), true );
			$this->load_menus();
	}

	/**
	 * Load all menus.
	 */
	public function load_menus() {
		if ( defined( 'BP_PLATFORM_VERSION' ) ) {
			$this->register_screen(
				'bb_logged_in_profile',
				__( 'Profile', 'buddyboss-app' ),
				array(
					'id'   => 'user',
					'type' => 'buddyboss',
				),
				array( 'deeplink_slug' => 'profile' )
			);
			$this->register_screen(
				'bb_logged_in_view',
				__( 'View Profile', 'buddyboss-app' ),
				array(
					'id'   => 'user',
					'type' => 'buddyboss',
				),
				array( 'deeplink_slug' => 'view' )
			);
			// BuddyBoss Platform Menus.
			if ( function_exists( 'bp_is_active' ) ) {
				if ( bp_is_active( 'activity' ) ) {
					$this->register_screen(
						'bb_logged_in_activity',
						__( 'Activity', 'buddyboss-app' ),
						array(
							'id'   => 'activity',
							'type' => 'buddyboss',
						),
						array( 'deeplink_slug' => 'activity' )
					);
				}
				if ( bp_is_active( 'groups' ) ) {
					$this->register_screen(
						'bb_logged_in_groups',
						__( 'Groups', 'buddyboss-app' ),
						array(
							'id'   => 'user-friends',
							'type' => 'buddyboss',
						),
						array( 'deeplink_slug' => 'groups' )
					);
				}
				if ( bp_is_active( 'media' ) ) {
					$this->register_screen(
						'bb_logged_in_photos',
						__( 'Photos', 'buddyboss-app' ),
						array(
							'id'   => 'image',
							'type' => 'buddyboss',
						),
						array( 'deeplink_slug' => 'photos' )
					);
					if ( ( function_exists( 'bp_is_group_video_support_enabled' ) && bp_is_group_video_support_enabled() ) || ( function_exists( 'bp_is_profile_video_support_enabled' ) && bp_is_profile_video_support_enabled() ) ) {
						$this->register_screen(
							'bb_logged_in_videos',
							__( 'Videos', 'buddyboss-app' ),
							array(
								'id'   => 'video',
								'type' => 'buddyboss',
							),
							array( 'deeplink_slug' => 'videos' )
						);
					}
				}
				if ( bp_is_active( 'friends' ) ) {
					$this->register_screen(
						'bb_logged_in_connections',
						__( 'Connections', 'buddyboss-app' ),
						array(
							'id'   => 'user-plus',
							'type' => 'buddyboss',
						),
						array( 'deeplink_slug' => 'connections' )
					);
				}
				if ( function_exists( 'bbpress' ) || ( function_exists( 'bp_is_active' ) && bp_is_active( 'forums' ) ) ) {
					$this->register_screen(
						'bb_logged_in_forums',
						__( 'Forums', 'buddyboss-app' ),
						array(
							'id'   => 'comments-square',
							'type' => 'buddyboss',
						),
						array( 'deeplink_slug' => 'forums' )
					);
				}
				if ( function_exists( 'bp_disable_invite_member_type' ) && true === bp_disable_invite_member_type() && bp_is_active( 'invites' ) ) {
					$this->register_screen(
						'bb_logged_in_invites',
						__( 'Invites', 'buddyboss-app' ),
						array(
							'id'   => 'envelope-open',
							'type' => 'buddyboss',
						),
						array( 'deeplink_slug' => 'invites' )
					);
				}
			}
		}
	}

	/**
	 * Hide BB logged in member screens if platform plugin disable.
	 *
	 * @param array $metaboxes Array of metaboxes.
	 *
	 * @return mixed
	 */
	public function hide_on_no_bb_logged_in( $metaboxes ) {
		if ( ! defined( 'BP_PLATFORM_VERSION' ) ) {
			unset( $metaboxes['bb_logged_in'] );
		}

		return $metaboxes;
	}

}
