<?php
/**
 * App menu setting class.
 *
 * @package BuddyBossApp\Menus\Types
 */

namespace BuddyBossApp\Menus\Types;

use BuddyBossApp\AppSettings;

/**
 * Class App Settings menus.
 *
 * @package BuddyBossApp\Menus\Types
 */
class AppSettingsMenus extends CoreAbstract {

	/**
	 * Setup method.
	 *
	 * @return mixed|void
	 */
	public function setup() {
		$this->register_screen_group( 'app_settings', __( 'Settings', 'buddyboss-app' ), array( 'deeplink_base' => 'settings' ) );
		$this->load_menus();
	}

	/**
	 * Load all menus.
	 */
	public function load_menus() {
		$this->register_screen(
			'app_settings',
			__( 'Settings', 'buddyboss-app' ),
			array(
				'id'   => 'cog',
				'type' => 'buddyboss',
			),
			array( 'deeplink_slug' => 'settings' )
		);
		if ( bbapp_is_active( 'push_notification' ) ) {
			$this->register_screen(
				'push_notification_preferences',
				__( 'Push Notifications', 'buddyboss-app' ),
				array(
					'id'   => 'comment-notification',
					'type' => 'buddyboss',
				),
				array( 'deeplink_slug' => 'push-notifications' )
			);
		}

		if ( defined( 'BP_PLATFORM_VERSION' ) ) {
			$this->register_screen(
				'email_preferences',
				__( 'Email Preferences', 'buddyboss-app' ),
				array(
					'id'   => 'envelope',
					'type' => 'buddyboss',
				),
				array( 'deeplink_slug' => 'email-preferences' ),
				null,
				null,
				true
			);
			$this->register_screen(
				'privacy_settings',
				__( 'Privacy Settings', 'buddyboss-app' ),
				array(
					'id'   => 'lock-alt',
					'type' => 'buddyboss',
				),
				array( 'deeplink_slug' => 'privacy-settings' ),
				null,
				null,
				true
			);
			$this->register_screen(
				'export_data',
				__( 'Export Data', 'buddyboss-app' ),
				array(
					'id'   => 'cloud-download',
					'type' => 'buddyboss',
				),
				array( 'deeplink_slug' => 'export-data' ),
				null,
				null,
				true
			);
		}

		$this->register_screen(
			'app_about',
			__( 'About', 'buddyboss-app' ),
			array(
				'id'   => 'exclamation',
				'type' => 'buddyboss',
			),
			array( 'deeplink_slug' => 'about' )
		);
		if ( AppSettings::instance()->get_setting_value( 'support_email.enabled' ) ) {
			$this->register_screen(
				'app_feedback',
				__( 'Feedback', 'buddyboss-app' ),
				array(
					'id'   => 'thumbs-up',
					'type' => 'buddyboss',
				),
				array( 'deeplink_slug' => 'feedback' )
			);
		}
	}
}
