<?php
/**
 * Holds menu abstract class functionalitu.
 *
 * @package BuddyBossApp\Menus
 */

namespace BuddyBossApp\Menus;

/**
 * Class MenuAbstract
 *
 * @package BuddyBossApp\Menus
 * @deprecated We don't recommend to use this class.
 */
class MenuAbstract {

	/**
	 * Menu data.
	 *
	 * @var $menu
	 */
	protected $menu;

	/**
	 * Construct function.
	 */
	public function __construct() {
		add_filter( 'bbapp_custom_app_screen', array( $this, 'add_custom_screen' ) );
		add_filter( 'bbapp_get_menu_icon', array( $this, 'menu_icon' ), 10, 2 );
		add_action( 'bbapp_menu_metabox_render', array( $this, 'metabox_render' ), 10, 3 );
		add_filter( 'bbapp_get_menu_result', array( $this, 'get_menu_result' ), 10, 3 );
	}

	/**
	 * Add custom menu.
	 *
	 * @param array $custom_app_screens Custom app screens.
	 *
	 * @return mixed
	 */
	public function add_custom_screen( $custom_app_screens ) {
		$custom_app_screens[] = $this->menu;

		return $custom_app_screens;
	}

	/**
	 * Update default menu icon.
	 *
	 * @param array  $icon_defaults Icon data.
	 * @param string $item_name     Item name.
	 *
	 * @return mixed|string[]
	 */
	public function menu_icon( $icon_defaults, $item_name ) {
		if ( $item_name === $this->menu['object'] ) {
			$icon_defaults = $this->menu['icon'];
		}

		return $icon_defaults;
	}

	/**
	 * Prepare menu item.
	 *
	 * @param string $name  Menu name.
	 * @param string $label Menu label.
	 * @param string $icon  Menu icon.
	 */
	public function register_custom_app_screen( $name, $label, $icon ) {

		$default_menu = array(
			'id'   => uniqid(),
			'type' => 'custom_screen',
			'data' => array(),
		);

		$this->menu = wp_parse_args(
			array(
				'object'   => $name,
				'label'    => $label,
				'original' => $label,
				'icon'     => array(
					'uri'                => $icon,
					'monochrome_setting' => array(),
				),
			),
			$default_menu
		);
	}

	/**
	 * Add metabox for menu.
	 *
	 * @param string $menu_id   Menu id.
	 * @param array  $menu      Array of menu.
	 */
	public static function metabox( $menu_id, $menu ) {}

	/**
	 * Result for menu response.
	 *
	 * @param array $menu    Array of menu.
	 * @param array $request Array of request parameters.
	 *
	 * @return mixed
	 */
	public static function get_results( $menu, $request ) {
		unset( $menu['settings'] );

		return $menu;
	}

	/**
	 * Metabox callback.
	 *
	 * @param string $menu_id   Menu id.
	 * @param array  $menu      Array of menu.
	 * @param string $menu_name Menu name.
	 */
	public function metabox_render( $menu_id, $menu, $menu_name ) {
		if ( $this->menu['type'] === $menu['type'] && $menu_name === $this->menu['object'] ) {
			if ( method_exists( get_parent_class( $this ), 'metabox' ) ) {
				static::metabox( $menu_id, $menu );
			}
		}
	}

	/**
	 * Metabox callback.
	 *
	 * @param array  $menu      Array of menus.
	 * @param array  $request   Array of request parameters.
	 * @param string $menu_name Menu name.
	 */
	public function get_menu_result( $menu, $request, $menu_name ) {

		if ( ! empty( $menu ) && $menu_name === $this->menu['object'] ) {
			if ( method_exists( get_parent_class( $this ), 'get_results' ) ) {
				return static::get_results( $menu, $request );
			}
		}

		return $menu;
	}
}
