<?php
/**
 * Holds IAP related menu functionality.
 *
 * @package BuddyBossApp\Menus
 */

namespace BuddyBossApp\Menus;

use BuddyBossApp\Admin\InAppPurchases\Helpers;

/**
 * IapProducts menus class.
 */
class IapProducts {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return IapProducts
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * IapProducts constructor.
	 */
	public function __construct() {
	}

	/**
	 * IAP Product menu metabox callback method.
	 *
	 * @param string $menu_id Menu id.
	 * @param array  $menu    Menu data.
	 */
	public function menu_metabox( $menu_id, $menu ) {
		$default = array(
			'settings' => array(
				'iap_products' => array(),
			),
		);
		$menu    = array_replace_recursive( $default, $menu );
	}

	/**
	 * Menu result on rest api response.
	 *
	 * @param array  $menu    Menu data.
	 * @param object $request Rest request.
	 *
	 * @return array|mixed|string
	 */
	public function menu_result( $menu, $request ) {
		$default = array(
			'settings' => array(
				'iap_products' => array(),
			),
		);

		$menu = array_replace_recursive( $default, $menu );

		$product_args = array(
			'global_subscription' => true,
		);

		$bbapp_products = Helpers::get_products( $product_args );

		if ( ! empty( $bbapp_products ) ) {
			$menu['data']['iap_products'] = array_column( $bbapp_products, 'product_id' );
		}

		unset( $menu['settings'] );

		return $menu;
	}
}
