<?php

namespace BuddyBossApp\Library;

/**
 * Composer class
 */
class Composer {

	/**
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Composer
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * This function is used to get FirebaseJWT instance from scoped vendor
	 *
	 * @return Composer\FirebaseJWT|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\FirebaseJWT
	 */
	function firebase_jwt_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\FirebaseJWT' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\FirebaseJWT::instance();
		}

		return \BuddyBossApp\Library\Composer\FirebaseJWT::instance();
	}

	/**
	 * This function is used to get FontLib instance from scoped vendor
	 *
	 * @return Composer\FontLib|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\FontLib
	 */
	function font_lib_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\FontLib' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\FontLib::instance();
		}

		return \BuddyBossApp\Library\Composer\FontLib::instance();
	}

	/**
	 * This function is used to get google_client instance from scoped vendor
	 *
	 * @return Composer\Google|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\Google
	 */
	function google_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\Google' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\Google::instance();
		}

		return \BuddyBossApp\Library\Composer\Google::instance();
	}

	/**
	 * This function is used to get GooglePlayAPI instance from scoped vendor
	 *
	 * @since 2.9.1
	 * @return Composer\GooglePlayAPI|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\GooglePlayAPI
	 */
	public function google_play_api_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\GooglePlayAPI' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\GooglePlayAPI::instance();
		}

		return \BuddyBossApp\Library\Composer\GooglePlayAPI::instance();
	}

	/**
	 * This function is used to get apple_client instance from scoped vendor
	 *
	 * @return Composer\Apple|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\Apple
	 */
	function apple_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\Apple' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\Apple::instance();
		}

		return \BuddyBossApp\Library\Composer\Apple::instance();
	}


	/**
	 * This function is used to get GuzzleHTTP instance from scoped vendor
	 *
	 * @return Composer\GuzzleHTTP|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\GuzzleHTTP
	 */
	function guzzle_http_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\GuzzleHTTP' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\GuzzleHTTP::instance();
		}

		return \BuddyBossApp\Library\Composer\GuzzleHTTP::instance();
	}

	/**
	 * This function is used to get Mobile_Detect instance from scoped vendor
	 *
	 * @return Composer\Mobile_Detect|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\Mobile_Detect
	 */
	function mobile_detect_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\QRCode' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\Mobile_Detect::instance();
		}

		return \BuddyBossApp\Library\Composer\Mobile_Detect::instance();
	}

	/**
	 * This function is used to get PlistParser instance from scoped vendor
	 *
	 * @return Composer\PlistParser|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\PlistParser
	 */
	function plist_parser_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\PlistParser' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\PlistParser::instance();
		}

		return \BuddyBossApp\Library\Composer\PlistParser::instance();
	}

	/**
	 * This function is used to get QRCode instance from scoped vendor
	 *
	 * @return Composer\QRCode|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\QRCode
	 */
	function qr_code_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\QRCode' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\QRCode::instance();
		}

		return \BuddyBossApp\Library\Composer\QRCode::instance();
	}

	/**
	 * This function is used to get ReceiptValidator instance from scoped vendor
	 *
	 * @return Composer\ReceiptValidator|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\ReceiptValidator
	 */
	function receipt_validator_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\ReceiptValidator' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\ReceiptValidator::instance();
		}

		return \BuddyBossApp\Library\Composer\ReceiptValidator::instance();
	}

	/**
	 * This function is used to get Uuid instance from scoped vendor
	 *
	 * @return Composer\Uuid|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\Uuid
	 */
	public function uuid_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\Uuid' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\Uuid::instance();
		}

		return \BuddyBossApp\Library\Composer\Uuid::instance();
	}

	/**
	 * This function is used to get Uuid instance from scoped vendor
	 *
	 * @return Composer\AppStoreServerAPI|\BuddyBossAppScoping\BuddyBossApp\Library\Composer\AppStoreServerAPI
	 */
	public function appstore_server_api_instance() {
		if ( class_exists( '\BuddyBossAppScoping\BuddyBossApp\Library\Composer\AppStoreServerAPI' ) ) {
			return \BuddyBossAppScoping\BuddyBossApp\Library\Composer\AppStoreServerAPI::instance();
		}

		return \BuddyBossApp\Library\Composer\AppStoreServerAPI::instance();
	}
}
