<?php

namespace BuddyBossAppScoping;

class RequestsTest_IDNAEncoder extends PHPUnit_Framework_TestCase
{
    public static function specExamples()
    {
        return array(array("他们为什么不说中文", "xn--ihqwcrb4cv8a8dqg056pqjye"), array("3年B組金八先生", "xn--3B-ww4c5e180e575a65lsy2b"));
    }
    /**
     * @dataProvider specExamples
     */
    public function testEncoding($data, $expected)
    {
        $result = Requests_IDNAEncoder::encode($data);
        $this->assertEquals($expected, $result);
    }
    /**
     * @expectedException Requests_Exception
     */
    public function testASCIITooLong()
    {
        $data = \str_repeat("abcd", 20);
        $result = Requests_IDNAEncoder::encode($data);
    }
    /**
     * @expectedException Requests_Exception
     */
    public function testEncodedTooLong()
    {
        $data = \str_repeat("他", 60);
        $result = Requests_IDNAEncoder::encode($data);
    }
    /**
     * @expectedException Requests_Exception
     */
    public function testAlreadyPrefixed()
    {
        $result = Requests_IDNAEncoder::encode("xn--他");
    }
    public function testASCIICharacter()
    {
        $result = Requests_IDNAEncoder::encode("a");
        $this->assertEquals('a', $result);
    }
    public function testTwoByteCharacter()
    {
        $result = Requests_IDNAEncoder::encode("¶");
        // Pilcrow character
        $this->assertEquals('xn--tba', $result);
    }
    public function testThreeByteCharacter()
    {
        $result = Requests_IDNAEncoder::encode("€");
        // Euro symbol
        $this->assertEquals('xn--lzg', $result);
    }
    public function testFourByteCharacter()
    {
        $result = Requests_IDNAEncoder::encode("𤭢");
        // Chinese symbol?
        $this->assertEquals('xn--ww6j', $result);
    }
    /**
     * @expectedException Requests_Exception
     */
    public function testFiveByteCharacter()
    {
        $result = Requests_IDNAEncoder::encode("\xfb\xb6\xb6\xb6\xb6");
    }
    /**
     * @expectedException Requests_Exception
     */
    public function testSixByteCharacter()
    {
        $result = Requests_IDNAEncoder::encode("\xfd\xb6\xb6\xb6\xb6\xb6");
    }
    /**
     * @expectedException Requests_Exception
     */
    public function testInvalidASCIICharacterWithMultibyte()
    {
        $result = Requests_IDNAEncoder::encode("\x00¶");
    }
    /**
     * @expectedException Requests_Exception
     */
    public function testUnfinishedMultibyte()
    {
        $result = Requests_IDNAEncoder::encode("\xc2");
    }
    /**
     * @expectedException Requests_Exception
     */
    public function testPartialMultibyte()
    {
        $result = Requests_IDNAEncoder::encode("\xc2¶");
    }
}
