<?php

declare (strict_types=1);
namespace BuddyBossAppScoping\Readdle\AppStoreServerAPI\Tests\Unit\Util;

use BuddyBossAppScoping\PHPUnit\Framework\TestCase;
use BuddyBossAppScoping\Readdle\AppStoreServerAPI\Util\ArrayTypeCaseGenerator;
final class ArrayTypeCaseGeneratorTest extends TestCase
{
    public function testArrayTypeCaseGeneratorNullables() : void
    {
        $testTypeCaseMap = ['int' => ['notNullableInt', '?nullableInt'], 'bool' => ['notNullableBool', '?nullableBool'], 'float' => ['notNullableFloat', '?nullableFloat'], 'string' => ['notNullableString', '?nullableString'], 'array' => ['notNullableArray', '?nullableArray']];
        $testInput = ['notNullableInt' => '1', 'nullableInt' => null, 'notNullableBool' => 1, 'nullableBool' => null, 'notNullableFloat' => '1.1', 'nullableFloat' => null, 'notNullableString' => 's', 'nullableString' => null, 'notNullableArray' => [1], 'nullableArray' => null];
        $testOutput = [];
        $testTypeCaster = (new ArrayTypeCaseGenerator())($testInput, $testTypeCaseMap);
        foreach ($testTypeCaster as $prop => $value) {
            $testOutput[$prop] = $value;
        }
        $this->assertSame(['notNullableInt' => 1, 'nullableInt' => null, 'notNullableBool' => \true, 'nullableBool' => null, 'notNullableFloat' => 1.1, 'nullableFloat' => null, 'notNullableString' => 's', 'nullableString' => null, 'notNullableArray' => [1], 'nullableArray' => null], $testOutput);
    }
    public function testArrayTypeCaseGeneratorNotNullables() : void
    {
        $testTypeCaseMap = ['int' => ['notNullableInt', 'nullableInt'], 'bool' => ['notNullableBool', 'nullableBool'], 'float' => ['notNullableFloat', 'nullableFloat'], 'string' => ['notNullableString', 'nullableString'], 'array' => ['notNullableArray', 'nullableArray']];
        $testInput = ['notNullableInt' => '1', 'nullableInt' => null, 'notNullableBool' => 1, 'nullableBool' => null, 'notNullableFloat' => '1.1', 'nullableFloat' => null, 'notNullableString' => 's', 'nullableString' => null, 'notNullableArray' => [1], 'nullableArray' => null];
        $testOutput = [];
        $testTypeCaster = (new ArrayTypeCaseGenerator())($testInput, $testTypeCaseMap);
        foreach ($testTypeCaster as $prop => $value) {
            $testOutput[$prop] = $value;
        }
        $this->assertSame(['notNullableInt' => 1, 'nullableInt' => 0, 'notNullableBool' => \true, 'nullableBool' => \false, 'notNullableFloat' => 1.1, 'nullableFloat' => 0.0, 'notNullableString' => 's', 'nullableString' => '', 'notNullableArray' => [1], 'nullableArray' => []], $testOutput);
    }
}
