<?php

declare (strict_types=1);
namespace BuddyBossAppScoping\Readdle\AppStoreServerAPI\Response;

use BuddyBossAppScoping\Readdle\AppStoreServerAPI\Exception\MalformedJWTException;
use BuddyBossAppScoping\Readdle\AppStoreServerAPI\Util\JWT;
use BuddyBossAppScoping\Readdle\AppStoreServerAPI\Request\AbstractRequest;
use BuddyBossAppScoping\Readdle\AppStoreServerAPI\TransactionInfo;
/**
 * @method static TransactionInfoResponse createFromString(string $string, AbstractRequest $originalRequest)
 */
final class TransactionInfoResponse extends AbstractResponse
{
    /**
     * A customer's in-app purchase transaction.
     */
    protected TransactionInfo $transactionInfo;
    /**
     * @throws MalformedJWTException
     */
    protected function __construct(array $properties, AbstractRequest $originalRequest)
    {
        $this->transactionInfo = TransactionInfo::createFromRawTransactionInfo(JWT::parse($properties['signedTransactionInfo']));
        unset($properties['signedTransactionInfo']);
        parent::__construct($properties, $originalRequest);
    }
    /**
     * Returns a customer's in-app purchase transaction.
     */
    public function getTransactionInfo() : TransactionInfo
    {
        return $this->transactionInfo;
    }
}
