<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace BuddyBossAppScoping\Google\Service\Iam;

class ServiceAccount extends \BuddyBossAppScoping\Google\Model
{
    /**
     * @var string
     */
    public $description;
    /**
     * @var bool
     */
    public $disabled;
    /**
     * @var string
     */
    public $displayName;
    /**
     * @var string
     */
    public $email;
    /**
     * @var string
     */
    public $etag;
    /**
     * @var string
     */
    public $name;
    /**
     * @var string
     */
    public $oauth2ClientId;
    /**
     * @var string
     */
    public $projectId;
    /**
     * @var string
     */
    public $uniqueId;
    /**
     * @param string
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }
    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * @param bool
     */
    public function setDisabled($disabled)
    {
        $this->disabled = $disabled;
    }
    /**
     * @return bool
     */
    public function getDisabled()
    {
        return $this->disabled;
    }
    /**
     * @param string
     */
    public function setDisplayName($displayName)
    {
        $this->displayName = $displayName;
    }
    /**
     * @return string
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * @param string
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }
    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * @param string
     */
    public function setEtag($etag)
    {
        $this->etag = $etag;
    }
    /**
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }
    /**
     * @param string
     */
    public function setName($name)
    {
        $this->name = $name;
    }
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * @param string
     */
    public function setOauth2ClientId($oauth2ClientId)
    {
        $this->oauth2ClientId = $oauth2ClientId;
    }
    /**
     * @return string
     */
    public function getOauth2ClientId()
    {
        return $this->oauth2ClientId;
    }
    /**
     * @param string
     */
    public function setProjectId($projectId)
    {
        $this->projectId = $projectId;
    }
    /**
     * @return string
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * @param string
     */
    public function setUniqueId($uniqueId)
    {
        $this->uniqueId = $uniqueId;
    }
    /**
     * @return string
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(ServiceAccount::class, 'BuddyBossAppScoping\\Google_Service_Iam_ServiceAccount');
