<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace BuddyBossAppScoping\Google\Service\AndroidPublisher;

class SubscribeWithGoogleInfo extends \BuddyBossAppScoping\Google\Model
{
    /**
     * @var string
     */
    public $emailAddress;
    /**
     * @var string
     */
    public $familyName;
    /**
     * @var string
     */
    public $givenName;
    /**
     * @var string
     */
    public $profileId;
    /**
     * @var string
     */
    public $profileName;
    /**
     * @param string
     */
    public function setEmailAddress($emailAddress)
    {
        $this->emailAddress = $emailAddress;
    }
    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * @param string
     */
    public function setFamilyName($familyName)
    {
        $this->familyName = $familyName;
    }
    /**
     * @return string
     */
    public function getFamilyName()
    {
        return $this->familyName;
    }
    /**
     * @param string
     */
    public function setGivenName($givenName)
    {
        $this->givenName = $givenName;
    }
    /**
     * @return string
     */
    public function getGivenName()
    {
        return $this->givenName;
    }
    /**
     * @param string
     */
    public function setProfileId($profileId)
    {
        $this->profileId = $profileId;
    }
    /**
     * @return string
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * @param string
     */
    public function setProfileName($profileName)
    {
        $this->profileName = $profileName;
    }
    /**
     * @return string
     */
    public function getProfileName()
    {
        return $this->profileName;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(SubscribeWithGoogleInfo::class, 'BuddyBossAppScoping\\Google_Service_AndroidPublisher_SubscribeWithGoogleInfo');
