<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace BuddyBossAppScoping\Google\Service\AndroidPublisher;

class SplitApkMetadata extends \BuddyBossAppScoping\Google\Model
{
    /**
     * @var bool
     */
    public $isMasterSplit;
    /**
     * @var string
     */
    public $splitId;
    /**
     * @param bool
     */
    public function setIsMasterSplit($isMasterSplit)
    {
        $this->isMasterSplit = $isMasterSplit;
    }
    /**
     * @return bool
     */
    public function getIsMasterSplit()
    {
        return $this->isMasterSplit;
    }
    /**
     * @param string
     */
    public function setSplitId($splitId)
    {
        $this->splitId = $splitId;
    }
    /**
     * @return string
     */
    public function getSplitId()
    {
        return $this->splitId;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(SplitApkMetadata::class, 'BuddyBossAppScoping\\Google_Service_AndroidPublisher_SplitApkMetadata');
