<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace BuddyBossAppScoping\Google\Service\AndroidPublisher;

class InternalAppSharingArtifact extends \BuddyBossAppScoping\Google\Model
{
    /**
     * @var string
     */
    public $certificateFingerprint;
    /**
     * @var string
     */
    public $downloadUrl;
    /**
     * @var string
     */
    public $sha256;
    /**
     * @param string
     */
    public function setCertificateFingerprint($certificateFingerprint)
    {
        $this->certificateFingerprint = $certificateFingerprint;
    }
    /**
     * @return string
     */
    public function getCertificateFingerprint()
    {
        return $this->certificateFingerprint;
    }
    /**
     * @param string
     */
    public function setDownloadUrl($downloadUrl)
    {
        $this->downloadUrl = $downloadUrl;
    }
    /**
     * @return string
     */
    public function getDownloadUrl()
    {
        return $this->downloadUrl;
    }
    /**
     * @param string
     */
    public function setSha256($sha256)
    {
        $this->sha256 = $sha256;
    }
    /**
     * @return string
     */
    public function getSha256()
    {
        return $this->sha256;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(InternalAppSharingArtifact::class, 'BuddyBossAppScoping\\Google_Service_AndroidPublisher_InternalAppSharingArtifact');
