<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace BuddyBossAppScoping\Google\Service\AndroidManagement;

class KeyedAppState extends \BuddyBossAppScoping\Google\Model
{
    /**
     * @var string
     */
    public $createTime;
    /**
     * @var string
     */
    public $data;
    /**
     * @var string
     */
    public $key;
    /**
     * @var string
     */
    public $lastUpdateTime;
    /**
     * @var string
     */
    public $message;
    /**
     * @var string
     */
    public $severity;
    /**
     * @param string
     */
    public function setCreateTime($createTime)
    {
        $this->createTime = $createTime;
    }
    /**
     * @return string
     */
    public function getCreateTime()
    {
        return $this->createTime;
    }
    /**
     * @param string
     */
    public function setData($data)
    {
        $this->data = $data;
    }
    /**
     * @return string
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * @param string
     */
    public function setKey($key)
    {
        $this->key = $key;
    }
    /**
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * @param string
     */
    public function setLastUpdateTime($lastUpdateTime)
    {
        $this->lastUpdateTime = $lastUpdateTime;
    }
    /**
     * @return string
     */
    public function getLastUpdateTime()
    {
        return $this->lastUpdateTime;
    }
    /**
     * @param string
     */
    public function setMessage($message)
    {
        $this->message = $message;
    }
    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * @param string
     */
    public function setSeverity($severity)
    {
        $this->severity = $severity;
    }
    /**
     * @return string
     */
    public function getSeverity()
    {
        return $this->severity;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(KeyedAppState::class, 'BuddyBossAppScoping\\Google_Service_AndroidManagement_KeyedAppState');
