<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace BuddyBossAppScoping\Google\Service\AndroidEnterprise;

class ProductApprovalEvent extends \BuddyBossAppScoping\Google\Model
{
    /**
     * @var string
     */
    public $approved;
    /**
     * @var string
     */
    public $productId;
    /**
     * @param string
     */
    public function setApproved($approved)
    {
        $this->approved = $approved;
    }
    /**
     * @return string
     */
    public function getApproved()
    {
        return $this->approved;
    }
    /**
     * @param string
     */
    public function setProductId($productId)
    {
        $this->productId = $productId;
    }
    /**
     * @return string
     */
    public function getProductId()
    {
        return $this->productId;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(ProductApprovalEvent::class, 'BuddyBossAppScoping\\Google_Service_AndroidEnterprise_ProductApprovalEvent');
