<?php

/**
 * Class MaskPatternTesterTest
 *
 * @filesource   MaskPatternTesterTest.php
 * @created      24.11.2017
 * @package      chillerlan\QRCodeTest\Data
 * @author       Smiley <smiley@chillerlan.net>
 * @copyright    2017 Smiley
 * @license      MIT
 */
namespace BuddyBossAppScoping\chillerlan\QRCodeTest\Data;

use BuddyBossAppScoping\chillerlan\QRCode\QROptions;
use BuddyBossAppScoping\chillerlan\QRCode\Data\Byte;
use BuddyBossAppScoping\chillerlan\QRCode\Data\MaskPatternTester;
use BuddyBossAppScoping\chillerlan\QRCodeTest\QRTestAbstract;
class MaskPatternTesterTest extends QRTestAbstract
{
    protected $FQCN = MaskPatternTester::class;
    // coverage
    public function testMaskpattern()
    {
        $matrix = (new Byte(new QROptions(['version' => 10]), 'test'))->initMatrix(3, \true);
        $this->assertSame(4243, (new MaskPatternTester($matrix))->testPattern());
    }
}
