<?php

namespace BuddyBossAppScoping;

/**
 * itunes connect client
 */
use BuddyBossAppScoping\MingYuanYun\AppStore\Client;
/**
 * Class ItunesConnectClient
 */
class ItunesConnectClient
{
    /**
     * @param $iss
     * @param $kid
     * @param $secret
     *
     * @return Google_Client|Client
     * @throws \MingYuanYun\AppStore\Exceptions\ConfigException
     */
    public static function get_client($iss, $kid, $secret)
    {
        global $client;
        if (isset($client)) {
            return $client;
        }
        $config = ['iss' => $iss, 'kid' => $kid, 'secret' => $secret];
        try {
            $client = new Client($config);
            // get jwt auth token, expired after 20 minutes later
            $token = $client->getToken();
            // set request auth header
            $headers = ['Authorization' => 'Bearer ' . $token];
            $client->setHeaders($headers);
        } catch (\Throwable $e) {
        }
        return $client;
    }
}
