<?php

namespace BuddyBossAppScoping;

use BuddyBossAppScoping\MingYuanYun\AppStore\Client;
class IConnectInAppPurchases extends \BuddyBossAppScoping\MingYuanYun\AppStore\Api\AbstractApi
{
    protected $app_id;
    public function __construct(string $app_id, Client $client)
    {
        $this->app_id = $app_id;
        parent::__construct($client);
    }
    /**
     * Query Deprecated In-App Purchases (V1).
     * This method is for backward compatibility only and is deprecated.
     *
     * @param array $params
     *
     * @return mixed
     */
    public function query(array $params = [])
    {
        return $this->get("/apps/{$this->app_id}/inAppPurchases", $params);
    }
    /**
     * Query In-App Purchases (V2) - for non-subscription purchases.
     *
     * @param array $params
     *
     * @return mixed
     */
    public function queryInAppPurchasesV2(array $params = [])
    {
        return $this->get("/apps/{$this->app_id}/inAppPurchasesV2", $params);
    }
    /**
     * List Subscription Groups for the App.
     *
     * @param array $params
     *
     * @return mixed
     */
    public function listSubscriptionGroups(array $params = [])
    {
        return $this->get("/apps/{$this->app_id}/subscriptionGroups", $params);
    }
    /**
     * List Subscriptions in a Subscription Group.
     *
     * @param string $subscriptionGroupId
     * @param array $params
     *
     * @return mixed
     */
    public function listSubscriptionsInGroup(string $subscriptionGroupId, array $params = [])
    {
        return $this->get("/subscriptionGroups/{$subscriptionGroupId}/subscriptions", $params);
    }
}
