<?php

namespace BuddyBossAppScoping;

use BuddyBossAppScoping\MingYuanYun\AppStore\Client;
class IConnectCert extends \BuddyBossAppScoping\MingYuanYun\AppStore\Api\AbstractApi
{
    public function all(array $params = [])
    {
        return $this->get('/certificates', $params);
    }
    public function create(string $cert_type, string $csr_file)
    {
        $data = ['data' => ['type' => 'certificates', 'attributes' => ['certificateType' => $cert_type, 'csrContent' => \file_get_contents($csr_file)]]];
        return $this->postJson('/certificates', $data);
    }
}
