<?php

namespace BuddyBossAppScoping;

use BuddyBossAppScoping\MingYuanYun\AppStore\Client;
class IConnectBundleId extends \BuddyBossAppScoping\MingYuanYun\AppStore\Api\AbstractApi
{
    public function all(array $params = [])
    {
        return $this->get('/bundleIds', $params);
    }
    public function register($name, $platform, $bundleId)
    {
        $data = ['data' => ['type' => 'bundleIds', 'attributes' => ['identifier' => $bundleId, 'name' => $name, 'platform' => $platform]]];
        return $this->postJson('/bundleIds', $data);
    }
    public function query($bId, array $params = [])
    {
        return $this->get("/bundleIds/{$bId}/bundleIdCapabilities", $params);
    }
}
