<?php

/**
 * Class use for get Uuid for scoped version.
 *
 * @package BuddyBossApp\Library\Composer;
 */
namespace BuddyBossAppScoping\BuddyBossApp\Library\Composer;

use BuddyBossAppScoping\Ramsey\Uuid\UuidInterface;
/**
 * Class uuid.
 */
class Uuid
{
    /**
     * Class instance.
     *
     * @var $instance
     */
    private static $instance;
    /**
     * Get the instance of the class.
     *
     * @return Uuid
     */
    public static function instance()
    {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class();
        }
        return self::$instance;
    }
    /**
     * This Function Is Used To Get uuid Instance From Scoped Vendor
     *
     * @return UuidInterface
     */
    public function uuid4()
    {
        return \BuddyBossAppScoping\Ramsey\Uuid\Uuid::uuid4();
    }
}
