<?php

namespace BuddyBossAppScoping\BuddyBossApp\Library\Composer;

use BuddyBossAppScoping\ReceiptValidator\iTunes\Validator;
class ReceiptValidator
{
    private static $instance;
    /**
     * Get the instance of the class.
     *
     * @return ReceiptValidator
     */
    public static function instance()
    {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class();
        }
        return self::$instance;
    }
    /**
     * This Function Is Used To Get Guzzle Http Client Instance From Scoped Vendor
     *
     * @return Validator
     */
    function receipt_validator($iap_env)
    {
        return new Validator($iap_env);
    }
    /**
     * @return string
     */
    function validator_endpoint_production()
    {
        return Validator::ENDPOINT_PRODUCTION;
    }
}
