<?php

namespace BuddyBossAppScoping\BuddyBossApp\Library\Composer;

class GuzzleHTTP
{
    private static $instance;
    /**
     * Get the instance of the class.
     *
     * @return GuzzleHTTP
     */
    public static function instance()
    {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class();
        }
        return self::$instance;
    }
    /**
     * This Function Is Used To Get Guzzle Http Client Instance From Scoped Vendor
     * Params: Base Uri
     *
     * @param $config
     *
     * @return \GuzzleHttp\Client
     */
    function guzzle_http($config)
    {
        return new \BuddyBossAppScoping\GuzzleHttp\Client($config);
    }
}
