<?php

namespace BuddyBossAppScoping\BuddyBossApp\Library\Composer;

use BuddyBossAppScoping\Google\Service\AndroidPublisher;
use BuddyBossAppScoping\Google\Service\AndroidPublisher\AppEdit;
use BuddyBossAppScoping\Google\Service\AndroidPublisher\ProductPurchasesAcknowledgeRequest;
use BuddyBossAppScoping\Google\Service\AndroidPublisher\SubscriptionPurchasesAcknowledgeRequest;
use BuddyBossAppScoping\Google_Client;
use BuddyBossAppScoping\Google_Service_AndroidPublisher;
use BuddyBossAppScoping\Google_Service_AndroidPublisher_AppEdit;
class Google
{
    private static $instance;
    /**
     * Get the instance of the class.
     *
     * @return Google
     */
    public static function instance()
    {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class();
        }
        return self::$instance;
    }
    /**
     * This Function Is Used To Get Google_client Instance From Scoped Vendor
     *
     * @return Google_Client
     */
    function Google_Client()
    {
        return new Google_Client();
    }
    /**
     * This Function Is Used To Get Google_Service_AndroidPublisher_AppEdit Instance From Scoped Vendor
     *
     * @return Google_Service_AndroidPublisher_AppEdit
     */
    function Google_Service_AndroidPublisher_AppEdit()
    {
        return new AppEdit();
    }
    /**
     * This Function Is Used To Get Google_Service_AndroidPublisher Instance From Scoped Vendor
     *
     * @param $client
     *
     * @return Google_Service_AndroidPublisher
     */
    function Google_Service_AndroidPublisher($client)
    {
        return new AndroidPublisher($client);
    }
    /**
     * This Function Is Used To Get Google_Service_AndroidPublisher_SubscriptionPurchasesAcknowledgeRequest Instance From Scoped Vendor
     *
     * @return \Google_Service_AndroidPublisher_SubscriptionPurchasesAcknowledgeRequest
     */
    function Google_Service_AndroidPublisher_SubscriptionPurchasesAcknowledgeRequest()
    {
        return new SubscriptionPurchasesAcknowledgeRequest();
    }
    /**
     * This Function Is Used To Get Google_Service_AndroidPublisher_SubscriptionPurchasesAcknowledgeRequest Instance From Scoped Vendor
     *
     * @return \Google_Service_AndroidPublisher_ProductPurchasesAcknowledgeRequest
     */
    function Google_Service_AndroidPublisher_ProductPurchasesAcknowledgeRequest()
    {
        return new ProductPurchasesAcknowledgeRequest();
    }
}
