<?php

namespace BuddyBossAppScoping\BuddyBossApp\Library\Composer;

class FontLib
{
    private static $instance;
    /**
     * Get the instance of the class.
     *
     * @return FontLib
     */
    public static function instance()
    {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class();
        }
        return self::$instance;
    }
    /**
     * This Function Is Used To Get Guzzle Http Client Instance From Scoped Vendor
     * Params: Font Path
     *
     * @param $font_path
     *
     * @return null|\FontLib\TrueType\File
     * @throws \FontLib\Exception\FontNotFoundException
     */
    function font_lib($font_path)
    {
        return \BuddyBossAppScoping\FontLib\Font::load($font_path);
    }
}
