<?php

namespace BuddyBossAppScoping\BuddyBossApp\Library\Composer;

class FirebaseJWT
{
    private static $instance;
    /**
     * Get the instance of the class.
     *
     * @return FirebaseJWT
     */
    public static function instance()
    {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class();
        }
        return self::$instance;
    }
    /**
     * This Function Is Used To Get Firebase Jwt Instance Encode From Scoped Vendor
     * Params: Access Token, Jwt Secret
     *
     * @param $access_token
     * @param $jwt_secret
     *
     * @return string
     */
    function firebase_jwt_encode($access_token, $jwt_secret)
    {
        return \BuddyBossAppScoping\Firebase\JWT\JWT::encode($access_token, $jwt_secret);
    }
    /**
     * This Function Is Used To Get Firebase Jwt Instance Decode From Scoped Vendor
     * Params: Access Token, Jwt Secret, Hash Secret
     *
     * @param $access_token
     * @param $jwt_secret
     * @param $hash_sec
     *
     * @return object
     */
    function firebase_jwt_decode($access_token, $jwt_secret, $hash_sec)
    {
        return \BuddyBossAppScoping\Firebase\JWT\JWT::decode($access_token, $jwt_secret, $hash_sec);
    }
}
