<?php

namespace BuddyBossAppScoping\BuddyBossApp\Library\Composer;

use http\Client;
class Apple
{
    private static $instance;
    /**
     * Get the instance of the class.
     *
     * @return Apple
     */
    public static function instance()
    {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class();
        }
        return self::$instance;
    }
    /**
     * This Function Is Used To Get IConnectApps Instance From Scoped Vendor
     *
     * @return \IConnectApps
     */
    function IConnectApps($client)
    {
        return new \BuddyBossAppScoping\IConnectApps($client);
    }
    /**
     * This Function Is Used To Get ItunesConnectClient Instance From Scoped Vendor
     *
     * @return \BuddyBossAppScoping\Google_Client|\MingYuanYun\AppStore\Client|\MingYuanYun\AppStore\Client
     * @throws \MingYuanYun\AppStore\Exceptions\ConfigException
     */
    function ItunesConnectClient($issuer_id, $key_id, $private_key)
    {
        return \BuddyBossAppScoping\ItunesConnectClient::get_client($issuer_id, $key_id, $private_key);
    }
    /**
     * This Function Is Used To Get IConnectBundleId Instance From Scoped Vendor
     *
     * @param $client
     *
     * @return \IConnectBundleId
     */
    function IConnectBundleId($client)
    {
        return new \BuddyBossAppScoping\IConnectBundleId($client);
    }
    /**
     * This Function Is Used To Get IConnectCert Instance From Scoped Vendor
     *
     * @param $client
     *
     * @return \IConnectCert
     */
    function IConnectCert($client)
    {
        return new \BuddyBossAppScoping\IConnectCert($client);
    }
    /**
     * This Function Is Used To Get IConnectDevices Instance From Scoped Vendor
     *
     * @param $client
     *
     * @return \IConnectDevices
     */
    function IConnectDevices($client)
    {
        return new \BuddyBossAppScoping\IConnectDevices($client);
    }
    /**
     * This Function Is Used To Get IConnectProfile Instance From Scoped Vendor
     *
     * @param $client
     *
     * @return \IConnectProfile
     */
    function IConnectProfile($client)
    {
        return new \BuddyBossAppScoping\IConnectProfile($client);
    }
    /**
     * This Function Is Used To Get IConnectInAppPurchases Instance From Scoped Vendor
     *
     * @param $ios_app_id
     * @param $client
     *
     * @return \IConnectInAppPurchases
     */
    function IConnectInAppPurchases($ios_app_id, $client)
    {
        return new \BuddyBossAppScoping\IConnectInAppPurchases($ios_app_id, $client);
    }
    /**
     * This Function Is Used To Get IConnectUsers Instance From Scoped Vendor
     *
     * @param $client
     *
     * @return \IConnectUsers
     */
    function IConnectUsers($client)
    {
        return new \BuddyBossAppScoping\IConnectUsers($client);
    }
}
